param(
	[bool]$AutoLogin = $false,
	[string]$Password = $null,
	[string]$OrganizationUid = $null

)

Write-Host "# Installation CC of SignageOS server #"

if ($OrganizationUid -ne $null) {
	$organizationUid | Out-File -FilePath "organizationUid.txt"
	$env:organizationUid = $OrganizationUid
}

."4-Powershell/Setup-SignageOS.ps1" install
# Check if the script ran successfully

Import-Module $PSScriptRoot\4-Powershell\AutoAdminLogon\AutoAdminLogon.psm1 -Force -ErrorAction SilentlyContinue
Import-Module $PSScriptRoot\4-Powershell\Create-SignageOSUser.ps1 -Force -ErrorAction SilentlyContinue

if ($LASTEXITCODE -eq 0) {
	# If the script ran successfully, disable the Kiosk user
	$KioskUser = "Kiosk01" # replace with the actual username
	Disable-LocalUser -Name $KioskUser
	Clear-AutoAdminLogon

	. $PSScriptRoot\4-Powershell\Setup-CC-services.ps1

	if ($AutoLogin) {
		# If AutoLogin is true, set AutoAdminLogon
		$securePassword = New-Object System.Security.SecureString
		$curretnUser = [Environment]::UserName # get the username of the current user

		if ($Password -eq "") {
			$securePassword = Read-PasswordWithConfirm -Help "Enter $($curretnUser) user password" -ConfirmHelp "Confirm $($curretnUser) user password"
			Set-AutoAdminLogon -Username $curretnUser -Password $securePassword
		} else {
			$securePassword = ConvertTo-SecureString -String $Password -AsPlainText -Force
			Set-AutoAdminLogon -Username $curretnUser -Password $securePassword
		}
	}
	if ($OrganizationUid -eq "") {
		 # Open a browser with a specific address
		 $url = "http://localhost:3000" # replace with the actual URL
		 Start-Process $url
	}

	New-Item -ItemType File -Path "C:\signageos\Settings\frontDisabled.txt" -Force
	Remove-Item Env:\organizationUid -ErrorAction SilentlyContinue
} else {
	# If the script did not run successfully, throw an error
	throw "Installation script failed with exit code $LASTEXITCODE"
}
