.$PSScriptRoot\Helper-Functions.ps1

$serverPaths= [System.Collections.ArrayList]@();
if ([Environment]::GetFolderPath('CommonStartup')) {
	$serverPaths.Add($(Join-Path $([Environment]::GetFolderPath('CommonStartup')) 'KioskDesktopServer.bat'));
}

$servicesNames = @(
	"signageosserver.exe";
	"signageosscreenshotserver.exe";
)

ForEach ($serviceName in $servicesNames) {
	$service = Get-WmiObject -Class Win32_Service -Filter "Name='$serviceName'"
	if ($service) {
		Stop-Service -Name $serviceName -Force -Confirm:$False
		$service.delete() | Out-Null

		Write-Host "Service $serviceName was stopped and deleted."
	} else {
		Write-Warning "Service $serviceName not found."
	}
}

Remove-ScheduledTask -TaskName "Create active console"

ForEach ($serverPath in $serverPaths) {
  if (Test-Path -Path $serverPath) {
    try {
      Remove-Item $serverPath -Recurse -Force -Confirm:$False -ErrorAction Stop
      Write-Host "Kiosk Server path $serverPath removed."
    } catch {
      Write-Host "ERROR: Failed to remove Kiosk Server path $serverPath. Try to reboot your computer and run this again." -ForegroundColor Red
    }
  } else {
    Write-Warning "Kiosk Server path $serverPath not found."
  }
}
