
[string[]] $UNSUPPORTED_WINDOWS_EDITION_ID_LIST = @(
	"Home";
	"Core"; # Core is alternative to Home
);

function Get-WindowsEditionId {
	return $(Get-WindowsEdition -Online).Edition;
}

function Invoke-UnsupportedWindowsEditionCheck {
	$currentEditionId = Get-WindowsEditionId;
	foreach ($UNSUPPORTED_EDITION_ID in $UNSUPPORTED_WINDOWS_EDITION_ID_LIST)
	{
		$isUnsupportedEdition = $currentEditionId -Match $UNSUPPORTED_EDITION_ID;

		if ($isUnsupportedEdition) {
			throw "Current Windows Edition is not supported. " +
				"'$currentEditionId' matched with unsupported '$UNSUPPORTED_EDITION_ID'.";
		}
	}
}
