﻿$windowsUpdateServiceName = "wuauserv"

$windowsUpdatesRegistryPath = "HKLM:\Software\Policies\Microsoft\Windows\WindowsUpdate\AU"
$noAutoUpdateRegistryArguments = @{
    Path = $windowsUpdatesRegistryPath;
    Name = "NoAutoUpdate";
    Value = "1";
    PropertyType = "DWORD";
}
$autoUpdatesOptionsRegistryArguments = @{
    Path = $windowsUpdatesRegistryPath;
    Name = "AUOptions";
    Value = "1";
    PropertyType = "DWORD";
}
$noAutoRebootRegistryArguments = @{
    Path = $windowsUpdatesRegistryPath;
    Name = "NoAutoRebootWithLoggedOnUsers";
    Value = "1";
    PropertyType = "DWORD";
}
if (-not (Test-Path $windowsUpdatesRegistryPath)) {
    New-Item -Path $windowsUpdatesRegistryPath -Force | Out-Null
}
New-ItemProperty @noAutoUpdateRegistryArguments -Force | Out-Null
New-ItemProperty @autoUpdatesOptionsRegistryArguments -Force | Out-Null
New-ItemProperty @noAutoRebootRegistryArguments -Force | Out-Null

Write-Host "Stopping Windows Update service"
Stop-Service $windowsUpdateServiceName

Write-Host "Disabling Windows Update service"
Set-Service $windowsUpdateServiceName -StartupType Disabled