﻿[string] $RootDirPath = $env:ContentRootFolder;
if (-not $RootDirPath) {
	throw "Missing ContentRootFolder variable"
}
[string] $NodeExecutablePath = $env:NodeExecutablePath;
if (-not $NodeExecutablePath) {
	throw "Missing NodeExecutablePath variable"
}
$DebugPort = 9222
$FirewallRuleName = 'KioskAllowChromiumRemoteDebug'

function Set-NodeFirewall(
	[string] $NodePath
) {
	Write-Host "Setting up node firewall rules"

	$NodeArguments = @{
		DisplayName   = "Allow Kiosk Node";
		Program       = "$NodePath";
		RemoteAddress = "Any";
		Action        = "Allow";
	}

	New-NetFirewallRule `
		@NodeArguments `
		-Direction Inbound `
		| Out-Null

	New-NetFirewallRule `
		@NodeArguments `
		-Direction Outbound `
		| Out-Null
}

function Set-WebViewFirewall($Port) {
	$FirewallRule = Get-NetFirewallRule | Where-Object { $_.Name -eq $FirewallRuleName }
	if ($FirewallRule) {
		Remove-NetFirewallRule -Name $FirewallRuleName
	}
	New-NetFirewallRule `
		-Name $FirewallRuleName `
		-DisplayName $FirewallRuleName `
		-Direction Inbound `
		-Protocol TCP `
		-LocalPort $Port `
		-Action Allow `
		-Enabled True `
		| Out-Null
}

function Set-WebViewProxy($Port) {
	netsh interface portproxy add v4tov6 `
	listenaddress=0.0.0.0 listenport=$Port `
	connectaddress=::1 connectport=$Port

	netsh interface portproxy show v4tov6
}

[string] $AbsoluteNodeExecutablePath = Join-Path $RootDirPath $NodeExecutablePath
Set-NodeFirewall $AbsoluteNodeExecutablePath
Set-WebViewFirewall $DebugPort
Set-WebViewProxy $DebugPort
