Import-Module "$PSScriptRoot\Get-PlainTextFromSecureString.psm1" -Force;

$powershell = "powershell.exe";

$KioskUsername = $env:KioskUsername
if ($env:KioskUserPassword) {
	$KioskUserPassword = $env:KioskUserPassword
} else {
	$KioskUserPassword = [System.Environment]::GetEnvironmentVariable("KioskUserPassword", [System.EnvironmentVariableTarget]::User)
}
if ($KioskUserPassword) {
	$KioskUserSecurePassword = ConvertTo-SecureString $KioskUserPassword -AsPlainText -Force
} else {
	$KioskUserSecurePassword = New-Object System.Security.SecureString
}
$kioskCredential = New-Object System.Management.Automation.PSCredential `
	-ArgumentList $KioskUsername, $KioskUserSecurePassword;

$script = {
	Set-ExecutionPolicy -Scope CurrentUser -ExecutionPolicy Bypass -Force;
	Import-Module "\signageos\server\powershell\display\Set-DisplayScalingLevel.psm1" -Force;
	Set-DisplayScalingLevel -Level -2;
};
$cwd = Resolve-Path "\signageos";
Start-Process `
	-FilePath $powershell `
	-ArgumentList $script.ToString() `
	-WorkingDirectory $cwd `
	-Credential $kioskCredential `
	-WindowStyle Hidden `
	-Wait;
