
$systemTmpPath = [System.Environment]::GetEnvironmentVariable(
  'TMP',
  [System.EnvironmentVariableTarget]::Machine
)
$dataDirRoot = $env:ContentRootFolder
$dataDirName = "signageos"

$contentDataDirPath = Join-Path $dataDirRoot $dataDirName
$tmpDataDirPath = Join-Path $env:TEMP $dataDirName
$systemTmpDataDirPath = Join-Path $systemTmpPath $dataDirName

$dataDirsPaths = @(
  $contentDataDirPath;
  $tmpDataDirPath;
  $systemTmpDataDirPath;
)

ForEach ($dataDirPath in $dataDirsPaths) {
  if (Test-Path -Path $dataDirPath) {
    try {
      Remove-Item $dataDirPath -Recurse -Force -Confirm:$False -ErrorAction Stop
      Write-Host "SignageOS Data directory $dataDirPath removed."
    } catch {
      throw "ERROR: Failed to remove SignageOS Data directory $dataDirPath. Try to reboot your computer and run this again."
    }
  } else {
    Write-Warning "SignageOS Data directory $dataDirPath not found."
  }
}
