# Base Directory
# This must match with the UpdateService/LocalePath entry ($Config.UpdateService.LocalePath)
# in the JSON configuration file if you want to use the automated update/Distribution features!
$global:BaseDirectory = (Get-Item .).FullName

# JSON configuration filename to use
$global:BaseConfig = "installation-definition.json"

try {
	$configFilename = "$BaseDirectory\$BaseConfig"
	Write-Host "Reading configuration file $configFilename"
	$configObject = Get-Content "$configFilename" -Raw -ErrorAction:SilentlyContinue -WarningAction:SilentlyContinue | ConvertFrom-Json -ErrorAction:SilentlyContinue -WarningAction:SilentlyContinue

	if (!($configObject)) {
		Write-Host -ForegroundColor Red "The Base configuration file is missing!"
		exit
	}
	else {
		$global:Config = $configObject.Config
		$global:Steps = $configObject.Steps

		Write-Host "Configuration loaded properly"
	}

} catch {
	Write-Host -ForegroundColor Red "The Base configuration file is missing!"
	exit
}