
function Install-ModuleVersion {
    param (
        [Parameter(Mandatory=$true)]
        [string]
        $Name,

        [Parameter(Mandatory=$true)]
        [version]
        $Version,

        [Parameter(Mandatory=$false)]
        [switch]
        $SkipPublisherCheck
    )

    Install-Module -Name $Name -RequiredVersion $Version -Force -Confirm:$False -SkipPublisherCheck:$SkipPublisherCheck
    Get-Module -Name $Name | Remove-Module
    Import-Module -Name $Name -RequiredVersion $Version -Force
}
