
function Invoke-EnsureAdministratorsGroup {
  $englishAdministratorsLocalGroupName = "Administrators"
  $actualAdministratorsLocalGroup = Get-LocalGroup -SID "S-1-5-32-544"

  $englishAdministratorsLocalGroupExists = $false;
  Get-LocalGroup | ForEach-Object {
    if ($_.Name -eq $englishAdministratorsLocalGroupName) {
      $englishAdministratorsLocalGroupExists = $true;
    }
  }

  if (-not $englishAdministratorsLocalGroupExists) {
    New-LocalGroup `
          -Name $englishAdministratorsLocalGroupName `
          -Description "Created due to locale naming incompability." `
          | Out-Null

    Net localgroup $actualAdministratorsLocalGroup.Name $englishAdministratorsLocalGroupName /add
  }
}
