$RootDir = $env:ContentRootFolder
$ServerPackageUrl = $env:ServerPackageUrl
$FrontendPackageUrl = $env:KioskFrontendArchivePath

$7ZipPath = Join-Path $PSScriptRoot '../1-Executables/7zip/x64/7z.exe'

$signagePath = Join-Path -Path $RootDir -ChildPath "signageos"
$logsPath = Join-Path -Path $signagePath -ChildPath "logs"
$serverPath = Join-Path -Path $signagePath -ChildPath "server"
$frontendPath = Join-Path -Path $signagePath -ChildPath "frontend"

New-Item -Path $RootDir -Name "signageos" -ItemType Directory -Force | Out-Null
New-Item -Path $signagePath -Name "logs" -ItemType Directory -Force | Out-Null
New-Item -Path $signagePath -Name "server" -ItemType Directory -Force | Out-Null
New-Item -Path $signagePath -Name "frontend" -ItemType Directory -Force | Out-Null
New-Item -Path $signagePath -Name "Packages" -ItemType Directory -Force | Out-Null

$serverArchivePath = $ServerPackageUrl
$frontendArchivePath = $FrontendPackageUrl

& $7ZipPath x $serverArchivePath -o"$serverPath" -r -y | Out-Null
& $7ZipPath x $frontendArchivePath -o"$frontendPath" -r -y | Out-Null
