[string] $WinLogonRegistryPath = "SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"

function Get-IsUserLoggedIn(
	[string] $User
) {
	$IsUserLoggedIn = $null -ne (quser | Where-Object { $_ -match "$User" })
	return $IsUserLoggedIn
}

function Get-UserSID(
	[string] $User
) {
	$UserAccount = Get-CimInstance -Query "Select * from Win32_USERACCOUNT where name='$User'"

	if ($null -eq $UserAccount) {
		throw "User $User does not exist"
	}

	return $UserAccount.SID
}
function Mount-UserRegistry(
	[string] $User,
	[string] $RegistryPath
) {
	$RegistryDataPath = Resolve-Path "\Users\$User\ntuser.dat"
	reg load $RegistryPath $RegistryDataPath | Out-Null
}

function Dismount-Registry(
	[string] $RegistryPath
) {
	reg unload $RegistryPath | Out-Null
}

function Clear-UserShell(
	[string] $User
) {
	$IsUserLoggedIn = Get-IsUserLoggedIn -User $User
	$UserSID = Get-UserSID -User $User
	$UserRegistryPath = "HKU\$UserSID"
	$UserWinLogonRegistryPath = "Registry::$UserRegistryPath\$WinLogonRegistryPath"

	try {
		if (-not $IsUserLoggedIn) {
			Mount-UserRegistry -User $User -RegistryPath $UserRegistryPath
		}

		$LoginProperty = Get-ItemProperty -Path $UserWinLogonRegistryPath
		if ($null -ne $LoginProperty.Shell) {
			Remove-ItemProperty `
				-Path $UserWinLogonRegistryPath `
				-Name "Shell" `
				-Force
		}
	}
	finally {
		if (-not $IsUserLoggedIn) {
			Dismount-Registry -RegistryPath $UserRegistryPath
		}
	}
}
