param(
    [Parameter(Mandatory=$true)]
    [string]$Name,
    
    [Parameter(Mandatory=$true)]
    [string]$KeyData
)

$ErrorActionPreference = "Stop"

# Create secrets directory if it doesn't exist
$secretsDir = Join-Path -Path $env:ProgramData -ChildPath "SignageOS\Secrets"
if (!(Test-Path -Path $secretsDir)) {
    New-Item -Path $secretsDir -ItemType Directory -Force | Out-Null
}

# File path for this specific key
$keyPath = Join-Path -Path $secretsDir -ChildPath "$Name.bin"

# Write the key data to the file
$KeyData | Out-File -FilePath $keyPath -Force

# Return success
@{
    Success = $true
}