param (
	[Parameter(Mandatory = $true)]
	[switch]
	$Locked
)

function Set-HotKeysLock([bool] $Enabled) {
	# Warning!
	# Keep formating
	# Read mapping from right to left like this <-
	# E0 is usually left prefix
	# E0 4D is Grey Right key used for blocking
	# https://www.win.tue.nl/~aeb/linux/kbd/scancodes-1.html
	# https://my.mech.utah.edu/~bamberg/resources/CapsLock/CapsLock.html
	# End of warning.
	$HexHashMap = `
	"00" + "00" + "00" + "00" + # Version header
	"00" + "00" + "00" + "00" + # Flags header
	"04" + "00" + "00" + "00" + # Number of mappings including null terminator
	"4D" + "E0" + "53" + "E0" + # Delete to Grey Right
	"4D" + "E0" + "5B" + "E0" + # LeftWindows to Grey Right
	"4D" + "E0" + "5C" + "E0" + # RightWindows to Grey Right
	"00" + "00" + "00" + "00"   # Null terminator

	$HashByteArray = [byte[]] ($HexHashMap -replace '..', '0x$&,' -split ',' -ne '')
	$KeyboardLayoutRegistryPath = "HKLM:\SYSTEM\CurrentControlSet\Control\Keyboard Layout"

	$ItemKey = @{
		Path = $KeyboardLayoutRegistryPath;
	}
	$PropertyKey = @{
		Name = "Scancode Map";
	}
	$Value = @{
		Value        = $HashByteArray;
		PropertyType = "BINARY";
	}

	if (-not (Test-Path @ItemKey)) {
		New-Item @ItemKey -Force | Out-Null
	}

	if ($Enabled) {
		New-ItemProperty @ItemKey @PropertyKey @Value -Force | Out-Null
	}
	else {
		$Property = $(Get-ItemProperty @ItemKey)."$($PropertyKey.Name)"
		if ($null -ne $Property) {
			Remove-ItemProperty @ItemKey @PropertyKey -Force | Out-Null
		}
	}
}

Set-HotKeysLock $Locked
