Param(
    [Parameter(Mandatory = $True, Position = 0)]
    [string] $DisplayPower
)

Add-Type -TypeDefinition @'
using System;
using System.Runtime.InteropServices;

namespace Utilities {
    public static class Display {

        public const int HWND_BROADCAST = 0xFFFF;
        public const uint WM_SYSCOMMAND = 0x0112;

        public const int SC_MONITORPOWER = 0xf170;
        public const int POWER_OFF = 2;

        public const int KEY_EVENT_FLAG_KEY_DOWN = 1;
        public const int KEY_EVENT_FLAG_KEY_UP = 2;

        public const int VIRTUAL_KEY_CODE_ESCAPE = 27;

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        private static extern bool PostMessage(int hWnd, uint Msg, int wParam, int lParam);
        
        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        static extern void keybd_event(byte bVk, byte bScan, int dwFlags, int dwExtraInfo);

        public static void PowerOff () {
            PostMessage(HWND_BROADCAST, WM_SYSCOMMAND, SC_MONITORPOWER, POWER_OFF);
        }
        
        public static void PowerOn () {
            keybd_event(VIRTUAL_KEY_CODE_ESCAPE, 0, KEY_EVENT_FLAG_KEY_DOWN, 0);
            keybd_event(VIRTUAL_KEY_CODE_ESCAPE, 0, KEY_EVENT_FLAG_KEY_UP, 0); 
        }
    }
}
'@

switch ($DisplayPower) {
    'on' {
        [Utilities.Display]::PowerOn()
        Break
    }
    'off' {
        [Utilities.Display]::PowerOff()
        Break
    }
    Default {
        throw "Unknown DisplayPower state $DisplayPower"
    }
}
