
namespace Display {

	public static class PrimaryDisplay {

		public static DisplaySettings GetDisplaySettings() {
			Win32.DEVMODE mode = GetDisplayMode();
			DisplaySettings settings = new DisplaySettings(mode.dmPelsHeight,
				mode.dmPelsWidth, mode.dmDisplayOrientation, mode.dmDisplayFrequency);

			return settings;
		}

		public static void SetDisplaySettings(int width, int height, int orientation, int framerate) {
			Win32.DEVMODE mode = GetDisplayMode();
			mode.dmDisplayOrientation = orientation;
			mode.dmPelsWidth = width;
			mode.dmPelsHeight = height;
			mode.dmDisplayFrequency = framerate;

			SetDisplayMode(mode);
		}

		private static Win32.DEVMODE GetDisplayMode() {
			Win32.DEVMODE mode = Win32.CreateDevMode();
			bool success = Win32.EnumDisplaySettings(null,
				Win32.ENUM_CURRENT_SETTINGS, ref mode);

			if (success) {
				return mode;
			} else {
				throw new System.Exception("Native enum display settings failed.");
			}
		}

		private static void SetDisplayMode(Win32.DEVMODE mode) {
			int testResult = Win32.ChangeDisplaySettings(ref mode,
				Win32.CDS_TEST);

			if (testResult == Win32.DISP_CHANGE_FAILED) {
				throw new System.Exception("Native change display settings test failed.");
			}

			int changeResult = Win32.ChangeDisplaySettings(ref mode,
				Win32.CDS_UPDATEREGISTRY);

			if (changeResult == Win32.DISP_CHANGE_SUCCESSFUL) {
				return;
			} else {
				throw new System.Exception("Native change display settings failed.");
			}
		}

	}

	public struct DisplaySettings
	{
		public int width;
		public int height;
		public int orientation;
		public int framerate;

		public DisplaySettings(int width, int height, int orientation, int framerate) {
			this.width = width;
			this.height = height;
			this.orientation = orientation;
			this.framerate = framerate;
		}
	}

}
