Param(
  [Parameter(Mandatory = $False, 
    ParameterSetName = "UnixTime")]
  [long]$UnixTime,

  [Parameter(Mandatory = $True,
    ParameterSetName = "UnixTimeMilliseconds")]
  [long]$UnixTimeMilliseconds,

  [Parameter(Mandatory = $False)]
  [string]$TimeZone
)

If ($TimeZone) {
  [Reflection.Assembly]::LoadFile("C:\signageos\Packages\TimeZoneConverter.3.2.0\lib\net45\TimeZoneConverter.dll") | Out-Null
  $windowsTimeZoneId = [TimeZoneConverter.TzConvert]::IanaToWindows($TimeZone)
  
  Set-TimeZone -Id $windowsTimeZoneId
}

If (-Not $UnixTime -And -Not $UnixTimeMilliseconds) {
  Write-Error -Exception ([System.ArgumentException]::new("Neither UnixTime nor UnixTimeMilliseconds set")) -ErrorAction Stop
}
Elseif ($UnixTime -And $UnixTimeMilliseconds) {
  Write-Error -Exception ([System.ArgumentException]::new("Set either UnixTime or UnixTimeMilliseconds")) -ErrorAction Stop
}

If ($UnixTime) {
  $date = [DateTimeOffset]::FromUnixTimeSeconds($UnixTime).DateTime.ToLocalTime()
}
Else {
  $date = [DateTimeOffset]::FromUnixTimeMilliseconds($UnixTimeMilliseconds).DateTime.ToLocalTime()
}

Set-Date $date