"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A generic function that, when given some branded type, can take a value with
 * the base type of the branded type, and cast that value to the branded type.
 * It fulfills the contract of a `Brander`.
 *
 * At runtime, this function simply returns the value as-is.
 *
 * @param underlying The value with a base type, to be casted
 * @return The same underlying value, but casted
 * @example
 * ```
 * type UserId = Brand<number, 'user'>;
 * const UserId: Brander<UserId> = identity;
 * ```
 */
function identity(underlying) {
    return underlying;
}
exports.identity = identity;
/**
 * Produces a `Brander<B>`, given a brand type `B`. This simply returns
 * `identity` but relies on type inference to give the return type the correct
 * type.
 *
 * @return `identity`
 * @example
 * ```
 * type UserId = Brand<number, 'user'>;
 * const UserId = make<UserId>();
 * const myUserId = UserId(42);
 * ```
 */
function make() {
    return identity;
}
exports.make = make;
