import { computeValue } from "../../../core";
import { adjustDate, isoWeek, isoWeekYear, parseTimezone } from "./_internal";
const $dateToParts = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  const d = new Date(args.date);
  const tz = parseTimezone(args.timezone);
  adjustDate(d, tz);
  const timePart = {
    hour: d.getUTCHours(),
    minute: d.getUTCMinutes(),
    second: d.getUTCSeconds(),
    millisecond: d.getUTCMilliseconds()
  };
  if (args.iso8601 == true) {
    return Object.assign(timePart, {
      isoWeekYear: isoWeekYear(d),
      isoWeek: isoWeek(d),
      isoDayOfWeek: d.getUTCDay() || 7
    });
  }
  return Object.assign(timePart, {
    year: d.getUTCFullYear(),
    month: d.getUTCMonth() + 1,
    day: d.getUTCDate()
  });
};
export {
  $dateToParts
};
