export interface IConnectionStringHost {
    host: string;
    port?: number;
}
export interface IConnectionStringParameters {
    scheme: string;
    username?: string;
    password?: string;
    hosts: IConnectionStringHost[];
    endpoint?: string;
    options?: any;
}
export declare class ConnectionStringParser {
    private static readonly DEFAULT_SCHEME;
    private readonly scheme;
    constructor(options?: IConnectionStringParameters);
    /**
     * Takes a connection string object and returns a URI string of the form:
     *
     * scheme://[username[:password]@]host1[:port1][,host2[:port2],...[,hostN[:portN]]][/[endpoint]][?options]
     * @param connectionStringObject The object that describes connection string parameters
     */
    format(connectionStringObject?: IConnectionStringParameters): string;
    /**
     * Takes a connection string URI of form:
     *
     *   scheme://[username[:password]@]host1[:port1][,host2[:port2],...[,hostN[:portN]]][/[endpoint]][?options]
     *
     * and returns an object of form:
     *
     *   {
     *     scheme: string,
     *     username?: string,
     *     password?: string,
     *     hosts: [ { host: string, port?: number }, ... ],
     *     endpoint?: string,
     *     options?: object
     *   }
     *
     * Where scheme and hosts will always be present. Other fields will only be present in the result if they were
     * present in the input.
     * @param uri The connection string URI
     */
    parse(uri: string): IConnectionStringParameters;
    /**
     * Formats the address portion of a connection string
     * @param connectionStringObject The object that describes connection string parameters
     */
    private _formatAddress(connectionStringObject);
    /**
     * Parses an address
     * @param addresses The address(es) to process
     */
    private _parseAddress(addresses);
    /**
     * Parses options
     * @param options The options to process
     */
    private _parseOptions(options);
}
