"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useAdapter = exports.NodeCacheAdapter = void 0;
const core_1 = require("@type-cacheable/core");
class NodeCacheAdapter {
    constructor(nodeCacheClient) {
        this.nodeCacheClient = nodeCacheClient;
        this.get = this.get.bind(this);
        this.del = this.del.bind(this);
        this.delHash = this.delHash.bind(this);
        this.getClientTTL = this.getClientTTL.bind(this);
        this.keys = this.keys.bind(this);
        this.set = this.set.bind(this);
    }
    getClientTTL() {
        return this.nodeCacheClient.options.stdTTL || 0;
    }
    get(cacheKey) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.nodeCacheClient.get(cacheKey);
        });
    }
    /**
     * set - Sets a key equal to a value in a NodeCache cache
     *
     * @param cacheKey The key to store the value under
     * @param value    The value to store
     * @param ttl      Time to Live (how long, in seconds, the value should be cached)
     *
     * @returns {Promise}
     */
    set(cacheKey, value, ttl) {
        return __awaiter(this, void 0, void 0, function* () {
            if (ttl) {
                this.nodeCacheClient.set(cacheKey, value, ttl);
                return;
            }
            this.nodeCacheClient.set(cacheKey, value);
        });
    }
    del(keyOrKeys) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.nodeCacheClient.del(keyOrKeys);
        });
    }
    keys(pattern) {
        return __awaiter(this, void 0, void 0, function* () {
            const allKeys = this.nodeCacheClient.keys();
            const regExp = new RegExp(pattern, 'g');
            const matchedKeys = [];
            for (const key of allKeys) {
                if (Array.isArray(key.match(regExp))) {
                    matchedKeys.push(key);
                }
            }
            return matchedKeys;
        });
    }
    delHash(hashKeyOrKeys) {
        return __awaiter(this, void 0, void 0, function* () {
            const finalDeleteKeys = Array.isArray(hashKeyOrKeys) ? hashKeyOrKeys : [hashKeyOrKeys];
            const deletePromises = finalDeleteKeys.map((key) => this.keys(key).then(this.del));
            yield Promise.all(deletePromises);
            return;
        });
    }
}
exports.NodeCacheAdapter = NodeCacheAdapter;
const useAdapter = (client, asFallback) => {
    const nodeCacheAdapter = new NodeCacheAdapter(client);
    if (asFallback) {
        core_1.default.setFallbackClient(nodeCacheAdapter);
    }
    else {
        core_1.default.setClient(nodeCacheAdapter);
    }
    return nodeCacheAdapter;
};
exports.useAdapter = useAdapter;
//# sourceMappingURL=index.js.map