import * as NodeCache from 'node-cache';
import { CacheClient } from '@type-cacheable/core';
export declare class NodeCacheAdapter implements CacheClient {
    private nodeCacheClient;
    constructor(nodeCacheClient: NodeCache);
    getClientTTL(): number;
    get<T>(cacheKey: string): Promise<T | undefined>;
    /**
     * set - Sets a key equal to a value in a NodeCache cache
     *
     * @param cacheKey The key to store the value under
     * @param value    The value to store
     * @param ttl      Time to Live (how long, in seconds, the value should be cached)
     *
     * @returns {Promise}
     */
    set<T>(cacheKey: string, value: T, ttl?: number): Promise<any>;
    del(keyOrKeys: string | string[]): Promise<any>;
    keys(pattern: string): Promise<string[]>;
    delHash(hashKeyOrKeys: string | string[]): Promise<any>;
}
export declare const useAdapter: (client: NodeCache, asFallback?: boolean | undefined) => NodeCacheAdapter;
