"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultStrategy = void 0;
class DefaultStrategy {
    handle(context) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const cachedValue = yield context.client.get(context.key);
                // If a value for the cacheKey was found in cache, simply return that.
                if (cachedValue !== undefined && cachedValue !== null) {
                    return cachedValue;
                }
            }
            catch (err) {
                if (context.fallbackClient) {
                    try {
                        const cachedValue = yield context.fallbackClient.get(context.key);
                        // If a value for the cacheKey was found in cache, simply return that.
                        if (cachedValue !== undefined && cachedValue !== null) {
                            return cachedValue;
                        }
                    }
                    catch (err) { }
                }
                if (context.debug) {
                    console.warn(`type-cacheable Cacheable cache miss on method ${context.originalMethod.name} due to client error: ${err.message}`);
                }
            }
            // On a cache miss, run the decorated method and cache its return value.
            const result = yield context.originalMethod.apply(context.originalMethodScope, context.originalMethodArgs);
            try {
                yield context.client.set(context.key, result, context.ttl);
            }
            catch (err) {
                if (context.fallbackClient) {
                    try {
                        yield context.fallbackClient.set(context.key, result, context.ttl);
                    }
                    catch (err) { }
                }
                if (context.debug) {
                    console.warn(`type-cacheable Cacheable set cache failure on method ${context.originalMethod.name} due to client error: ${err.message}`);
                }
            }
            return result;
        });
    }
}
exports.DefaultStrategy = DefaultStrategy;
//# sourceMappingURL=DefaultStrategy.js.map