"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultClearStrategy = void 0;
class DefaultClearStrategy {
    constructor() {
        this.handleDelete = (client, context) => __awaiter(this, void 0, void 0, function* () {
            // If hashesToClear is truthy, there is no individual cache keys to clear, so clear the provided hashes
            if (context.hashesToClear) {
                yield client.delHash(context.hashesToClear);
            }
            else if (context.isPattern) {
                // Delete keys that match a string pattern
                if (Array.isArray(context.key)) {
                    const keys = (yield Promise.all(context.key.map(client.keys))).reduce((accum, curr) => [...accum, ...curr], []);
                    yield client.del(keys);
                }
                else {
                    yield client.del(yield client.keys(context.key));
                }
            }
            else {
                // Delete the requested value from cache
                yield client.del(context.key);
            }
        });
    }
    handle(context) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.handleDelete(context.client, context);
            }
            catch (mainClientError) {
                if (context.fallbackClient) {
                    try {
                        yield this.handleDelete(context.fallbackClient, context);
                    }
                    catch (fallbackClientError) {
                        if (context.debug) {
                            console.warn(`type-cacheable CacheClear failure on method ${context.originalMethod.name} due to client error: ${mainClientError.message} and fallback client failure: ${fallbackClientError.message}`);
                        }
                    }
                    return;
                }
                else {
                    if (context.debug) {
                        console.warn(`type-cacheable CacheClear failure on method ${context.originalMethod.name} due to client error: ${mainClientError.message}`);
                    }
                }
            }
        });
    }
}
exports.DefaultClearStrategy = DefaultClearStrategy;
//# sourceMappingURL=DefaultClearStrategy.js.map