"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cacheable = void 0;
const util_1 = require("../util");
const index_1 = require("../index");
const strategies_1 = require("../strategies");
/**
 * Cacheable - This decorator allows you to first check if cached results for the
 *             decorated method exist. If so, return those, else run the decorated
 *             method, cache its return value, then return that value.
 *
 * @param options {CacheOptions}
 */
function Cacheable(options) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        return Object.assign(Object.assign({}, descriptor), { value: function (...args) {
                return __awaiter(this, void 0, void 0, function* () {
                    // Allow a client to be passed in directly for granularity, else use the connected
                    // client from the main CacheManager singleton.
                    const client = options && options.client ? options.client : index_1.default.client;
                    const fallbackClient = options && options.fallbackClient ? options.fallbackClient : index_1.default.fallbackClient;
                    if (options && options.noop && util_1.determineOp(options.noop, args, this)) {
                        return originalMethod.apply(this, args);
                    }
                    // If there is no client, no-op is enabled (else we would have thrown before),
                    // just return the result of the decorated method (no caching)
                    if (!client) {
                        // A caching client must exist if not set to noop, otherwise this library is doing nothing.
                        if (index_1.default.options.debug) {
                            console.warn('type-cacheable @Cacheable was not set up with a caching client. Without a client, type-cacheable is not serving a purpose.');
                        }
                        return originalMethod.apply(this, args);
                    }
                    const contextToUse = !index_1.default.options.excludeContext ? this : undefined;
                    const finalKey = util_1.getFinalKey(options && options.cacheKey, options && options.hashKey, propertyKey, args, contextToUse);
                    // TTL in seconds should prioritize options set in the decorator first,
                    // the CacheManager options second, and be undefined if unset.
                    const ttl = options && options.ttlSeconds
                        ? util_1.getTTL(options.ttlSeconds, args, contextToUse)
                        : index_1.default.options.ttlSeconds || undefined;
                    const strategy = util_1.getCacheStrategy((options === null || options === void 0 ? void 0 : options.strategy) || index_1.default.options.strategy || new strategies_1.DefaultStrategy(), args, contextToUse);
                    return strategy.handle({
                        debug: index_1.default.options.debug,
                        originalMethod,
                        originalMethodScope: this,
                        originalMethodArgs: args,
                        client,
                        fallbackClient,
                        key: finalKey,
                        ttl,
                    });
                });
            } });
    };
}
exports.Cacheable = Cacheable;
//# sourceMappingURL=Cacheable.js.map