import { CacheOptions } from '../interfaces';
/**
 * Cacheable - This decorator allows you to first check if cached results for the
 *             decorated method exist. If so, return those, else run the decorated
 *             method, cache its return value, then return that value.
 *
 * @param options {CacheOptions}
 */
export declare function Cacheable(options?: CacheOptions): (target: Object, propertyKey: string, descriptor: PropertyDescriptor) => {
    value: (...args: any[]) => Promise<any>;
    configurable?: boolean | undefined;
    enumerable?: boolean | undefined;
    writable?: boolean | undefined;
    get?(): any;
    set?(v: any): void;
};
