interface ISocket {
    on(event: string, listener: (message: any) => void): void;
    once(event: string, listener: (message: any) => void): void;
    emit(event: string, message: any, callback?: () => void): void;
    removeListener(event: string, listener: (message: any) => void): void;
    removeAllListeners(): void;
    close(): void;
}
export default ISocket;
export interface IMessageEvent {
    data: any;
    type: string;
}
export interface IErrorEvent {
    error: any;
    message: any;
    type: string;
}
export interface IResponseMessage {
    type: 'response';
    responseUid: string;
}
export interface IRequestMessage {
    type: 'request';
    event: string;
    payload: any;
    responseUid?: string;
}
export interface IPingMessage {
    type: 'ping';
}
export interface IPongMessage {
    type: 'pong';
}
export type IMessage = IRequestMessage | IResponseMessage | IPingMessage | IPongMessage;
export declare class UnconfirmedMessageError extends Error {
    readonly responseMessage: IResponseMessage;
    readonly requestMessage: IRequestMessage;
    readonly failedAt: Date;
    constructor(responseMessage: IResponseMessage, requestMessage: IRequestMessage, failedAt: Date);
}
export declare class UndeliveredEmitError extends Error {
    readonly requestMessage: IRequestMessage;
    readonly failedAt: Date;
    constructor(requestMessage: IRequestMessage, failedAt: Date);
}
export interface ISocketFactory {
    (socketUri: string, onConnected: () => void, onDisconnected: () => void, onError: (error: IErrorEvent | UnconfirmedMessageError | UndeliveredEmitError) => void): ISocket;
}
