"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRedisConnection = createRedisConnection;
const redis = __importStar(require("redis"));
const URL = __importStar(require("url"));
const genericGracefulExit_1 = require("../Events/genericGracefulExit");
const debug_1 = __importDefault(require("debug"));
const genericPool = require('generic-pool');
const debug = (0, debug_1.default)('@signageos/lib:Redis:redisConnectionFactory');
function infiniteRetryStrategy(options) {
    return Math.min(options.attempt * 100, 3e3);
}
function createRedisConnection(redisDsn, options = {}, onExit) {
    const connection = redis.createClient(redisDsn, {
        retry_strategy: options.infiniteReconnecting ? infiniteRetryStrategy : undefined,
    });
    const databases = {};
    const reconnectTimeout = 30e3;
    const gracefulExit = new genericGracefulExit_1.GenericGracefulExit('redis', reconnectTimeout, onExit);
    const pool = createPool(connection, gracefulExit, options);
    return {
        getDB(num) {
            if (databases[num] !== undefined) {
                return databases[num];
            }
            const parsedDsn = URL.parse(redisDsn, true);
            parsedDsn.query.db = num.toString();
            const subRedisDsn = URL.format(parsedDsn);
            const subConnection = createRedisConnection(subRedisDsn, options, onExit);
            subConnection.connect(); // it's practically not a promise
            databases[num] = subConnection;
            return subConnection;
        },
        connection,
        pool,
        connect() {
            connection.on('error', function (error) {
                return __awaiter(this, void 0, void 0, function* () {
                    console.error(error);
                    if (error.code === 'ECONNREFUSED' || error.code === 'EAI_AGAIN' || error.code === 'ENOTFOUND') {
                        yield gracefulExit.waitToConnectOrDie();
                    }
                });
            });
            connection.on('ready', () => {
                gracefulExit.connected();
            });
            return Promise.resolve();
        },
        close() {
            return __awaiter(this, void 0, void 0, function* () {
                yield new Promise((resolve, reject) => connection.quit((error) => (error ? reject(error) : resolve())));
                for (const num in databases) {
                    databases[num].close();
                    delete databases[num];
                }
            });
        },
        addListener() {
            // TODO implement
        },
        removeListener() {
            // TODO implement
        },
    };
}
const defaultOptions = {
    priorityRange: 3,
    min: 1,
    max: 100,
    autostart: true,
    testOnBorrow: true,
    acquireTimeoutMillis: 3e3,
};
function createPool(connection, gracefulExit, options) {
    const factory = {
        create() {
            return __awaiter(this, void 0, void 0, function* () {
                debug('Create connection');
                try {
                    const newConnection = connection.duplicate();
                    gracefulExit.connected();
                    newConnection.on('error', (error) => {
                        debug(error); // exceptions are thrown in promises
                    });
                    newConnection.on('end', () => {
                        debug('Closed connection');
                    });
                    return newConnection;
                }
                catch (e) {
                    debug('Caught error: %O', e);
                    gracefulExit.waitToConnectOrDie();
                }
                return Promise.reject('Unable to create connection redis');
            });
        },
        destroy(client) {
            return __awaiter(this, void 0, void 0, function* () {
                debug('Destroy connection');
                client.end(true);
            });
        },
        validate(client) {
            return __awaiter(this, void 0, void 0, function* () {
                return client.connected;
            });
        },
    };
    const pool = genericPool.createPool(factory, Object.assign(Object.assign({}, defaultOptions), options));
    pool.on('factoryCreateError', (error) => {
        debug('factoryCreateError %o', error);
        throw error;
    });
    pool.on('factoryDestroyError', (error) => {
        debug('factoryDestroyError %o', error);
        throw error;
    });
    return pool;
}
//# sourceMappingURL=redisConnectionFactory.js.map