"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.locked = locked;
const async_lock_1 = __importDefault(require("async-lock"));
const util = __importStar(require("util"));
const globalAsyncLock = new async_lock_1.default();
const asyncLocksMap = new WeakMap();
function acquireAsyncLock(options, instance) {
    if ((options === null || options === void 0 ? void 0 : options.scope) === undefined || (options === null || options === void 0 ? void 0 : options.scope) === 'global') {
        return globalAsyncLock;
    }
    else if ((options === null || options === void 0 ? void 0 : options.scope) === 'instance') {
        if (asyncLocksMap.has(instance)) {
            const lock = asyncLocksMap.get(instance);
            lock.countRunning++;
            return lock.asyncLock;
        }
        else {
            const asyncLock = new async_lock_1.default();
            asyncLocksMap.set(instance, { countRunning: 1, asyncLock });
            return asyncLock;
        }
    }
    throw new Error(`Invalid option scope=${options === null || options === void 0 ? void 0 : options.scope}`);
}
function releaseAsyncLock(options, instance) {
    if ((options === null || options === void 0 ? void 0 : options.scope) === 'instance') {
        const lock = asyncLocksMap.get(instance);
        lock.countRunning--;
        if (lock.countRunning === 0) {
            asyncLocksMap.delete(instance);
        }
    }
}
function locked(keyInitiator, options) {
    return function (_target, _propertyKey, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            return __awaiter(this, void 0, void 0, function* () {
                const key = typeof keyInitiator === 'function' ? keyInitiator.call(this, ...args) : keyInitiator;
                const currentAsyncLock = acquireAsyncLock(options, this);
                try {
                    return yield currentAsyncLock.acquire(key, () => __awaiter(this, void 0, void 0, function* () {
                        const returnValuePromise = originalMethod.apply(this, args);
                        if (!(returnValuePromise instanceof Promise)) {
                            throw new Error(`Synchronous methods must return Promise instance. But ${util.inspect(returnValuePromise)} given.`);
                        }
                        return yield returnValuePromise;
                    }), options);
                }
                finally {
                    releaseAsyncLock(options, this);
                }
            });
        };
    };
}
//# sourceMappingURL=lockedDecorator.js.map