"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.POSTGRE_DB_LABEL = void 0;
exports.default = default_1;
const dateTimeFactory_1 = require("../../DateTime/dateTimeFactory");
const lodash_1 = require("lodash");
exports.POSTGRE_DB_LABEL = 'postgreDB';
function default_1(postgreSqlConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        const databaseRequestMoment = (0, dateTimeFactory_1.now)();
        const response = yield postgreSqlConnection.connection.task(function (db) {
            return __awaiter(this, void 0, void 0, function* () {
                yield db.one('SELECT 1');
                const transferBytes = Math.pow(2, 15);
                const transferData = (0, lodash_1.times)(transferBytes / 2, (0, lodash_1.constant)('0')).join('');
                yield db.one('SELECT $1', [transferData]);
                const databaseTransferedMoment = (0, dateTimeFactory_1.now)();
                const responseTime = databaseTransferedMoment.diff(databaseRequestMoment).valueOf();
                const speed = (0, lodash_1.round)((transferBytes / responseTime) * 1e3);
                const dataTransfer = {
                    speed,
                    speedHumanized: humanizeUnit(speed, 1024) + 'B/s',
                };
                return dataTransfer;
            });
        });
        return response;
    });
}
function humanizeUnit(amount, baseStep, precision = 0) {
    const units = ['', 'K', 'M', 'G', 'T', 'P'];
    let unitIndex = 0;
    while (amount > baseStep && typeof units[unitIndex] !== 'undefined') {
        amount = amount / baseStep;
        unitIndex++;
    }
    return (0, lodash_1.round)(amount, precision) + String.fromCharCode(160) + units[unitIndex];
}
//# sourceMappingURL=postgreSqlStatusCheck.js.map