"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncEventEmitter = void 0;
/**
 * Same as regular NodeJS EventEmitter, but accepts async listeners.
 */
class AsyncEventEmitter {
    constructor() {
        this.listeners = {};
    }
    /**
     * Adds a listener for the event. The listener will be called every time the event is emitted. The listener may be async.
     */
    on(event, listener) {
        this.addNewListener(event, listener, false);
        return this;
    }
    /**
     * Adds a listener for the event. The listener will be called only once, the first time the event is emitted. The listener may be async.
     */
    once(event, listener) {
        this.addNewListener(event, listener, true);
        return this;
    }
    /**
     * Removes a listener for the event.
     */
    off(event, listener) {
        if (!this.listeners[event]) {
            return this;
        }
        this.listeners[event] = this.listeners[event].filter((l) => l.listener !== listener);
        return this;
    }
    /**
     * Alias for `on`.
     */
    addListener(event, listener) {
        return this.on(event, listener);
    }
    /**
     * Alias for `off`.
     */
    removeListener(event, listener) {
        return this.off(event, listener);
    }
    /**
     * Emits event and resolves, once all listeners have resolved.
     */
    emit(event, ...args) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.listeners[event]) {
                return;
            }
            const listeners = this.listeners[event];
            // Remove all listeners that should be called only once
            this.listeners[event] = listeners.filter(({ once }) => !once);
            yield Promise.all(listeners.map(({ listener }) => listener(...args)));
        });
    }
    addNewListener(event, listener, once) {
        if (!this.listeners[event]) {
            this.listeners[event] = [];
        }
        this.listeners[event].push({ listener, once });
    }
}
exports.AsyncEventEmitter = AsyncEventEmitter;
//# sourceMappingURL=AsyncEventEmitter.js.map