"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LRUCache = exports.LRUCacheEvent = void 0;
const events_1 = require("events");
const lru_cache_1 = require("lru-cache");
var LRUCacheEvent;
(function (LRUCacheEvent) {
    LRUCacheEvent["Hit"] = "hit";
    LRUCacheEvent["Miss"] = "miss";
    LRUCacheEvent["Set"] = "set";
})(LRUCacheEvent || (exports.LRUCacheEvent = LRUCacheEvent = {}));
/**
 * LRU cache with EventEmitter implementation
 *
 * Uses node-lru-cache library under the hood ( see docs. https://github.com/isaacs/node-lru-cache#readme )
 */
class LRUCache {
    constructor({ maxSize, maxAgeMs, updateAgeOnGet }) {
        this.emitter = new events_1.EventEmitter();
        this.cache = new lru_cache_1.LRUCache({
            max: maxSize,
            ttl: maxAgeMs,
            updateAgeOnGet,
        });
    }
    get(key) {
        const value = this.cache.get(key);
        this.emitter.emit(value === undefined ? LRUCacheEvent.Miss : LRUCacheEvent.Hit);
        return value;
    }
    set(key, value) {
        this.cache.set(key, value);
        this.emitter.emit(LRUCacheEvent.Set, this.cache.size);
    }
    on(event, listener) {
        this.emitter.on(event, listener);
    }
}
exports.LRUCache = LRUCache;
//# sourceMappingURL=lruCache.js.map