import { AuthenticationClientOptions } from 'auth0';
export type Auth0AuthenticationClientConfig = {
    domain: AuthenticationClientOptions['domain'];
    clientId: Required<AuthenticationClientOptions['clientId']>;
    clientSecret?: Required<AuthenticationClientOptions['clientSecret']>;
    connectionName?: string;
    idTokenSigningAlg?: AuthenticationClientOptions['idTokenSigningAlg'];
};
type LoginParams = {
    email: string;
    password: string;
    scope?: string;
};
export interface IAuth0AuthenticationClient {
    login: (params: LoginParams) => Promise<string>;
}
export declare class Auth0AuthenticationClient implements IAuth0AuthenticationClient {
    private authenticationClient;
    private domain;
    private connectionName;
    constructor({ domain, clientId, clientSecret, connectionName, idTokenSigningAlg, }: {
        domain: Auth0AuthenticationClientConfig['domain'];
        clientId: Auth0AuthenticationClientConfig['clientId'];
        clientSecret?: Auth0AuthenticationClientConfig['clientSecret'];
        connectionName?: Auth0AuthenticationClientConfig['connectionName'];
        idTokenSigningAlg?: Auth0AuthenticationClientConfig['idTokenSigningAlg'];
    });
    login: ({ email, password, scope }: LoginParams) => Promise<string>;
}
export {};
