/**
 * @param e string enum from which to retrieve the value
 * @param value string which should be converted to enum value
 * @returns enum value or undefined if value is not in enum
 * @throws error if enum is numeric or heterogeneous
 */
export declare function getEnumFromString<T>(e: {
    [s: string]: T;
}, value: string): T | undefined;
/**
 * Safely casts `val` of enum type `U` to enum of type `T`, only if enums
 * overlap. This is only compile-time cast and it does not validate the value
 * during runtime.
 *
 * **`castEnum` only works for enums with string values**
 *
 * @example
 * enum AB { a = "A", b = "B" }
 * enum ABC { A = "A", B = "B", C = "C" }
 *
 * const x: AB = castEnum(ABC.B) // does work
 * const x: AB = castEnum(ABC.C) // does not work
 */
export declare const castEnum: <T extends number | string, U extends `${T}`>(val: U) => T;
