export interface DownloadPackageArgs {
    packageName: string;
    downloadPath: string;
    version?: string;
}
export interface PublishPackageArgs {
    packageName: string;
    packagePath: string;
}
/**
 * Npm client interface
 *
 * Provides a common abstractions for programmatic access to npm registry
 */
export interface INpmClient {
    /** Returns all package versions from the registry */
    getPackageVersions(packageName: string): Promise<string[]>;
    /**
     * Downloads package tarball to a specified path
     *
     * @params version if not specified, will download the latest version
     * @returns path to the downloaded tarball
     */
    downloadPackage(args: DownloadPackageArgs): Promise<string>;
}
