"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.redirectConsoleToLogger = redirectConsoleToLogger;
/**
 * This function will redirect all logs that are logged to the console to the logger.
 *
 * The goal is to collect all logs that are not logged through the central logger and make them go through the logger.
 * That way we can control the format and destination of all logs no matter where they are logged.
 */
function redirectConsoleToLogger(logger) {
    console.debug = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        logger.debug(message, { args: args });
    };
    console.log = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        logger.info(message, { args: args });
    };
    console.info = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        logger.info(message, { args: args });
    };
    console.warn = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        logger.warn(message, { args: args });
    };
    console.error = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        logger.error(message, { args: args });
    };
}
//# sourceMappingURL=console.js.map