"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUniqueHash = generateUniqueHash;
exports.generateSalt = generateSalt;
var crypto_1 = require("crypto");
function generateUniqueHash(length) {
    if (length === void 0) { length = 50; }
    var hash = (0, crypto_1.createHash)('sha256');
    hash.update('' + new Date().valueOf() + Math.random());
    return hash.digest('hex').substring(0, length);
}
function generateSalt(length) {
    return (0, crypto_1.randomBytes)(length).toString('hex').substring(0, length);
}
//# sourceMappingURL=generator.js.map