"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDebugMethod = void 0;
exports.debug = debug;
exports.getDebugConfig = getDebugConfig;
exports.setDebugConfig = setDebugConfig;
var debug_1 = __importDefault(require("debug"));
var generator_1 = require("../Hash/generator");
var config = {
    serialize: false,
    logDuration: false,
};
function getDurationLog(start) {
    if (config.logDuration) {
        var duration = new Date().getTime() - start.getTime();
        return " (".concat(duration, "ms)");
    }
}
var createDebugMethod = function (localDebug) { return function (originalMethod, that, label, args) {
    var invocationUid = (0, generator_1.generateUniqueHash)(10);
    var start = new Date();
    localDebug.apply(void 0, __spreadArray(["invoking ".concat(label, " <").concat(invocationUid, ">")], serializeArgsIfEnabled(args), false));
    try {
        var returnValue = originalMethod.apply(that, args);
        if (returnValue instanceof Promise) {
            return returnValue
                .then(function (result) {
                localDebug("success ".concat(label, " <").concat(invocationUid, ">").concat(getDurationLog(start)), result);
                return result;
            })
                .catch(function (error) {
                localDebug("fail ".concat(label, " <").concat(invocationUid, ">").concat(getDurationLog(start)), error);
                throw error;
            });
        }
        else {
            localDebug("success ".concat(label, " <").concat(invocationUid, ">").concat(getDurationLog(start)), returnValue);
            return returnValue;
        }
    }
    catch (error) {
        localDebug("fail ".concat(label, " <").concat(invocationUid, ">").concat(getDurationLog(start)), error);
        throw error;
    }
}; };
exports.createDebugMethod = createDebugMethod;
function serializeArgsIfEnabled(args) {
    return args.map(function (arg) {
        if (typeof arg === 'object' && arg !== null && config.serialize) {
            return JSON.stringify(arg);
        }
        else {
            return arg;
        }
    });
}
/**
 * Add to a class method to debug it's calls
 *
 * For more information see https://www.npmjs.com/package/debug
 *
 * @param namespace Namespace of the debug logs. Run program with env variable DEBUG=<namespace> to enable the logs.
 */
function debug(namespace, debugFactory) {
    if (debugFactory === void 0) { debugFactory = debug_1.default; }
    var debugMethod = (0, exports.createDebugMethod)(debugFactory(namespace));
    return function (_target, propertyKey, descriptor) {
        var originalMethod = descriptor.value;
        descriptor.value = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return debugMethod(originalMethod, this, "".concat(this.constructor.name, ":").concat(propertyKey), args);
        };
    };
}
function getDebugConfig() {
    return config;
}
function setDebugConfig(newConfig) {
    config = __assign(__assign({}, config), newConfig);
}
//# sourceMappingURL=debugDecorator.js.map