"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUpdatedS3ClientConfigWithCustomEnvVars = getUpdatedS3ClientConfigWithCustomEnvVars;
var parsers_1 = require("../Parsers/parsers");
function getUpdatedS3ClientConfigWithCustomEnvVars(originalConfig) {
    var config = __assign({}, originalConfig);
    if (process.env.AWS_S3_FORCE_PATH_STYLE_URLS !== undefined) {
        config.forcePathStyle = (0, parsers_1.parseBoolean)(process.env.AWS_S3_FORCE_PATH_STYLE_URLS);
    }
    return config;
}
//# sourceMappingURL=config.js.map