"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendToDevice = sendToDevice;
exports.sendFromDevice = sendFromDevice;
exports.bindToDevice = bindToDevice;
exports.bindSpecificFromDevice = bindSpecificFromDevice;
exports.bindUnspecificFromDevice = bindUnspecificFromDevice;
exports.bindFailed = bindFailed;
var errors_1 = require("../errors");
var EXCHANGE_ACTIONS_TO_DEVICE = 'actionsToDevice';
var EXCHANGE_ACTIONS_NOT_DELIVERED_TO_DEVICE = 'actionsNotDeliveredToDevice';
var EXCHANGE_ACTIONS_FROM_DEVICE = 'actionsFromDevice';
var ALTERNATE_EXCHANGE_ACTIONS_FROM_DEVICE = 'alternateActionsFromDevice';
var UNSPECIFIC_ACTIONS_FROM_DEVICE_QUEUE_NAME = 'unspecificActionsFromDevice';
var FAILED_ACTIONS_CONSUMER_QUEUE_NAME = 'actionsNotDeliveredToDevice';
var DEFAULT_QUEUE_OPTIONS = {
    persistent: false, // default value for messages (all are not persistent)
    confirmable: true, // all messages enqueue promise is resolved after confirmation on rabbitmq
    prefetchCount: 500,
};
var TO_DEVICE_CONSUME_OPTIONS = {
    // to device queue is exclusive
    autoDelete: false,
    // to device queue is not recovered on restart
    durable: false,
    // to device queue is exclusive
    exclusive: true,
    respond: true,
};
var FROM_DEVICE_CONSUME_OPTIONS = {
    // queue from device and not delivered are persistent (not autoDelete)
    // will be kept even if 0 consumers (could happen only during BC deploys)
    autoDelete: false,
    // queue is durable (will not be deleted on restart to keep messages to be processed later)
    durable: true,
    queueType: 'quorum',
};
/**
 * @param postponable Postponable actions has to be delivered. When device is not connected at the time, it's postponed for later.
 * @param sessionUid Select a specific session (socket) to send message to. If specified, no other socket of single device get the action.
 * @param sendTimeout Specify how long it will wait for response until action is enqueued as not delivered action.
 */
function sendToDevice(amqpConnection, action, deviceUid, postponable, sessionUid, sendTimeout) {
    return __awaiter(this, void 0, void 0, function () {
        var headers, enqueueArgs, expectingResponse, error_1;
        var _a, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    headers = {
                        deviceUid: deviceUid,
                        sessionUid: sessionUid,
                        actionType: action.type,
                        postponable: postponable,
                    };
                    _c.label = 1;
                case 1:
                    _c.trys.push([1, 6, , 10]);
                    enqueueArgs = [
                        createChannelToDevice(amqpConnection, undefined),
                        action,
                        headers,
                        EXCHANGE_ACTIONS_TO_DEVICE,
                        action.type, // routing using action type to omit not listened actions
                        {
                            // delivery to device is not persistent message
                            persistent: false,
                            // expire messages after some time to prevent queue growing large in case of consumer failure
                            expiration: sendTimeout * 2,
                        },
                    ];
                    expectingResponse = !Boolean(sessionUid);
                    if (!expectingResponse) return [3 /*break*/, 3];
                    return [4 /*yield*/, (_a = amqpConnection.queuePublisher).enqueueExpectingResponse.apply(_a, __spreadArray(__spreadArray([], enqueueArgs, false), [sendTimeout], false))];
                case 2:
                    _c.sent();
                    return [3 /*break*/, 5];
                case 3: return [4 /*yield*/, (_b = amqpConnection.queuePublisher).enqueue.apply(_b, enqueueArgs)];
                case 4:
                    _c.sent();
                    _c.label = 5;
                case 5: return [3 /*break*/, 10];
                case 6:
                    error_1 = _c.sent();
                    if (!(error_1 instanceof errors_1.ResponseTimeoutError)) return [3 /*break*/, 8];
                    return [4 /*yield*/, enqueueFailedAction(amqpConnection, action, deviceUid, postponable, sessionUid)];
                case 7:
                    _c.sent();
                    return [3 /*break*/, 9];
                case 8: throw error_1;
                case 9: return [3 /*break*/, 10];
                case 10: return [2 /*return*/];
            }
        });
    });
}
function enqueueFailedAction(amqpConnection, action, deviceUid, postponable, sessionUid) {
    return __awaiter(this, void 0, void 0, function () {
        var headers;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    headers = {
                        deviceUid: deviceUid,
                        sessionUid: sessionUid,
                        actionType: action.type,
                        postponable: postponable,
                    };
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createChannelToDevice(amqpConnection, undefined), action, headers, EXCHANGE_ACTIONS_NOT_DELIVERED_TO_DEVICE, '', // fanout
                        { persistent: true })];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
/**
 * @param timestamp of action when it was sent from the device
 */
function sendFromDevice(amqpConnection, action, deviceUid, sessionUid, socketName, timestamp) {
    return __awaiter(this, void 0, void 0, function () {
        var headers;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    headers = {
                        deviceUid: deviceUid,
                        sessionUid: sessionUid,
                        socketName: socketName,
                        timestamp: timestamp,
                    };
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createChannelFromDevice(amqpConnection), action, headers, EXCHANGE_ACTIONS_FROM_DEVICE, // all actions are going through one queue from device
                        action.type, // routingKey=actionType, messages are routed to specific queue or to unspecific if nothing bound
                        { persistent: true })];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function bindToDevice(amqpConnection, consumerName, processUid, onAction) {
    return __awaiter(this, void 0, void 0, function () {
        var onRelatedAction, cancelConsumption;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    onRelatedAction = function (action, headers, ack, nack) { return __awaiter(_this, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, onAction(headers.deviceUid, headers.sessionUid, action, ack, nack)];
                                case 1:
                                    _a.sent();
                                    return [2 /*return*/];
                            }
                        });
                    }); };
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(createChannelToDevice(amqpConnection, processUid), getActionsToDeviceQueueName(consumerName, processUid), [{ exchangeName: EXCHANGE_ACTIONS_TO_DEVICE, persistent: false }], onRelatedAction, TO_DEVICE_CONSUME_OPTIONS)];
                case 1:
                    cancelConsumption = _a.sent();
                    return [2 /*return*/, cancelConsumption];
            }
        });
    });
}
/**
 * Binds action messages by a specific actionTypes to a single queue. The queue is named after the input group.
 * So, more action types are grouped together into single queue. This is preventing from stucking messages across more
 * priority leveled groups.
 * E.g.: The priority actions used for authentication, registration & verification should not be affected by telemetry actions in any way.
 * The priority actions has much more strict requirements on SLA.
 *
 * @param group the string name of group which will be used as a part of queue name.
 * @param actionTypes all types of actions which are bound to the queue.
 * @param onAction the callback which is called for every action bound above.
 */
function bindSpecificFromDevice(amqpConnection, group, actionTypes, onAction, options) {
    return __awaiter(this, void 0, void 0, function () {
        var fullOptions;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    fullOptions = __assign(__assign({}, FROM_DEVICE_CONSUME_OPTIONS), options);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createChannelSpecificFromDevice(amqpConnection, group), getSpecificActionsFromDeviceQueueName(group), actionTypes.map(function (actionType) { return ({ exchangeName: EXCHANGE_ACTIONS_FROM_DEVICE, persistent: true, routingKey: actionType }); }), function (action, headers) {
                            return onAction(action, headers.deviceUid, headers.sessionUid, headers.socketName, headers.timestamp);
                        }, fullOptions)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
/**
 * According to bindSpecificFromDevice, for all action types which were not bound there, the actions are fall backed to this consumption.
 * Those unspecific actions has self alternate exchange and appropriate single queue.
 * This consumption can be used for all not specifically bound actions, for example action logs of devices.
 *
 * @param onAction the callback which is called for every action ever not specifically bound by bindSpecificFromDevice.
 */
function bindUnspecificFromDevice(amqpConnection, onAction, options) {
    return __awaiter(this, void 0, void 0, function () {
        var fullOptions;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    fullOptions = __assign(__assign({}, FROM_DEVICE_CONSUME_OPTIONS), options);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createChannelUnspecificFromDevice(amqpConnection), UNSPECIFIC_ACTIONS_FROM_DEVICE_QUEUE_NAME, [{ exchangeName: ALTERNATE_EXCHANGE_ACTIONS_FROM_DEVICE, persistent: true }], function (action, headers) {
                            return onAction(action, headers.deviceUid, headers.sessionUid, headers.socketName, headers.timestamp);
                        }, fullOptions)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
function bindFailed(amqpConnection, onAction, options) {
    return __awaiter(this, void 0, void 0, function () {
        var fullOptions, onActionCallback;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    fullOptions = __assign(__assign({}, FROM_DEVICE_CONSUME_OPTIONS), options);
                    onActionCallback = function (action, headers, ack, nack) { return __awaiter(_this, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, onAction(action, headers.deviceUid, headers.postponable, ack, nack)];
                                case 1:
                                    _a.sent();
                                    return [2 /*return*/];
                            }
                        });
                    }); };
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(createChannelFailedToDevice(amqpConnection), FAILED_ACTIONS_CONSUMER_QUEUE_NAME, // failed messages are flat in one queue
                        [
                            // bind all not delivered actions (dead-lettered during delivering to device)
                            { exchangeName: EXCHANGE_ACTIONS_NOT_DELIVERED_TO_DEVICE, persistent: true },
                        ], onActionCallback, fullOptions)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
function createChannelFailedToDevice(amqpConnection, options) {
    var _this = this;
    var FAILED_ACTIONS_CHANNEL_NAME = 'actionsNotDeliveredToDevice';
    var fullOptions = __assign(__assign({}, DEFAULT_QUEUE_OPTIONS), options);
    return function () { return __awaiter(_this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(FAILED_ACTIONS_CHANNEL_NAME, fullOptions)];
                case 1:
                    channel = _a.sent();
                    return [4 /*yield*/, assertExchangeActionsNotDeliveredToDevice(channel)];
                case 2:
                    _a.sent();
                    return [2 /*return*/, channel];
            }
        });
    }); };
}
function createChannelFromDevice(amqpConnection, options) {
    var _this = this;
    var FROM_DEVICE_CHANNEL_NAME = 'actionsFromDevice';
    var fullOptions = __assign(__assign({}, DEFAULT_QUEUE_OPTIONS), options);
    return function () { return __awaiter(_this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(FROM_DEVICE_CHANNEL_NAME, fullOptions)];
                case 1:
                    channel = _a.sent();
                    return [4 /*yield*/, assertExchangeActionsFromDevice(channel)];
                case 2:
                    _a.sent();
                    return [2 /*return*/, channel];
            }
        });
    }); };
}
function createChannelSpecificFromDevice(amqpConnection, group, options) {
    var _this = this;
    var fromDeviceChannelName = "specificActionsFromDevice.".concat(group);
    var fullOptions = __assign(__assign({}, DEFAULT_QUEUE_OPTIONS), options);
    return function () { return __awaiter(_this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(fromDeviceChannelName, fullOptions)];
                case 1:
                    channel = _a.sent();
                    return [4 /*yield*/, assertExchangeActionsFromDevice(channel)];
                case 2:
                    _a.sent();
                    return [2 /*return*/, channel];
            }
        });
    }); };
}
function createChannelUnspecificFromDevice(amqpConnection, options) {
    var _this = this;
    var FROM_DEVICE_CHANNEL_NAME = 'unspecificActionsFromDevice';
    var fullOptions = __assign(__assign({}, DEFAULT_QUEUE_OPTIONS), options);
    return function () { return __awaiter(_this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(FROM_DEVICE_CHANNEL_NAME, fullOptions)];
                case 1:
                    channel = _a.sent();
                    return [4 /*yield*/, assertAlternateExchangeActionsFromDevice(channel)];
                case 2:
                    _a.sent();
                    return [2 /*return*/, channel];
            }
        });
    }); };
}
function createChannelToDevice(amqpConnection, processUid, options) {
    var _this = this;
    var TO_DEVICE_CHANNEL_NAME = 'actionsToDevice' + (typeof processUid === 'undefined' ? '' : '.' + processUid);
    var fullOptions = __assign(__assign({}, DEFAULT_QUEUE_OPTIONS), options);
    return function () { return __awaiter(_this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(TO_DEVICE_CHANNEL_NAME, fullOptions)];
                case 1:
                    channel = _a.sent();
                    return [4 /*yield*/, assertExchangeActionsToDevice(channel)];
                case 2:
                    _a.sent();
                    return [2 /*return*/, channel];
            }
        });
    }); };
}
function assertExchangeActionsToDevice(channel) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, channel.assertExchange(EXCHANGE_ACTIONS_TO_DEVICE, 'fanout')];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function assertExchangeActionsNotDeliveredToDevice(channel) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, channel.assertExchange(EXCHANGE_ACTIONS_NOT_DELIVERED_TO_DEVICE, 'fanout')];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function assertExchangeActionsFromDevice(channel) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, channel.assertExchange(EXCHANGE_ACTIONS_FROM_DEVICE, 'direct', {
                        alternateExchange: ALTERNATE_EXCHANGE_ACTIONS_FROM_DEVICE,
                    })];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function assertAlternateExchangeActionsFromDevice(channel) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, channel.assertExchange(ALTERNATE_EXCHANGE_ACTIONS_FROM_DEVICE, 'fanout')];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function getActionsToDeviceQueueName(consumerName, processUid) {
    return 'actionsToDevice.' + consumerName + '.' + processUid;
}
function getSpecificActionsFromDeviceQueueName(group) {
    return 'specificActionsFromDevice.' + group;
}
//# sourceMappingURL=deviceActionsQueue.js.map