import { IAMQPConnection } from '../amqpConnectionFactory';
import ICommand, { ICommandPayload } from './ICommand';
import INackOptions from '../INackOptions';
export declare const STORED_QUEUE_NAME = "stored_commands";
export declare const AGGREGATED_QUEUE_NAME = "aggregated_commands";
export interface IStoredCommand<TPayload extends ICommandPayload> extends ICommand<TPayload> {
    id: string;
    dispatchedAt: Date;
}
export type IAggregatedCommand = {
    commandId: string;
    succeededAt: Date;
} | {
    commandId: string;
    failedAt: Date;
    error: any;
};
export declare function createStoredCommand<TPayload extends ICommandPayload>(amqpConnection: IAMQPConnection, command: IStoredCommand<TPayload>): Promise<void>;
export declare function bindStoredCommands<TPayload extends ICommandPayload>(amqpConnection: IAMQPConnection, onCommand: (command: IStoredCommand<TPayload>) => Promise<void>): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
export declare function fetchNextStoredCommand<TPayload extends ICommandPayload>(amqpConnection: IAMQPConnection): Promise<IStoredCommand<TPayload> | null>;
export declare function markAggregatedCommandSucceeded<TPayload extends ICommandPayload>(amqpConnection: IAMQPConnection, command: IStoredCommand<TPayload>, succeededAt: Date): Promise<void>;
export declare function markAggregatedCommandFailed<TPayload extends ICommandPayload>(amqpConnection: IAMQPConnection, command: IStoredCommand<TPayload>, failedAt: Date, error: any): Promise<void>;
export declare function bindAggregatedCommands(amqpConnection: IAMQPConnection, onCommand: (aggregatedCommand: IAggregatedCommand, ack: () => void, nack: (options?: INackOptions) => void) => Promise<void>): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
export declare function fetchNextAggregatedCommand(amqpConnection: IAMQPConnection): Promise<IAggregatedCommand | null>;
export declare function purgeAll(amqpConnection: IAMQPConnection): Promise<void>;
export declare function deleteAll(amqpConnection: IAMQPConnection): Promise<void>;
export declare function prepareAll(amqpConnection: IAMQPConnection): Promise<void>;
