"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validKeys = void 0;
exports.default = validateTemperaturePolicy;
const Validation_1 = require("../../Validation/Validation");
const validateKeys_1 = require("../../Validation/validateKeys");
const validateTemperatureTelemetry_1 = require("../../Device/Telemetry/Validation/validateTemperatureTelemetry");
exports.validKeys = {
    temperatureLimit: true,
};
function validateTemperaturePolicy(settings) {
    var _a;
    const { temperatureLimit } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidTemperatureLimit = !(0, validateTemperatureTelemetry_1.isValidTemperatureValue)(temperatureLimit);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notValidTemperatureLimit) {
        validation.addError(new validateTemperatureTelemetry_1.InvalidTemperature(temperatureLimit));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
