"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidTelemetryIntervals = exports.validKeys = void 0;
exports.default = validateTelemetryIntervalsPolicy;
exports.isValidTelemetryIntervals = isValidTelemetryIntervals;
const TelemetryIntervals_1 = require("../../Device/MonitoringLog/TelemetryIntervals");
const validateKeys_1 = require("../../Validation/validateKeys");
const Validation_1 = require("../../Validation/Validation");
const validatePolicyItem_1 = require("./validatePolicyItem");
exports.validKeys = {
    telemetryIntervals: true,
};
function validateTelemetryIntervalsPolicy(settings) {
    var _a;
    const { telemetryIntervals } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidTelemetryIntervals = !isValidTelemetryIntervals(telemetryIntervals);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notValidTelemetryIntervals) {
        validation.addError(new InvalidTelemetryIntervals(telemetryIntervals));
    }
    validation.addError(...keysValidation.getErrors());
    const parseResult = TelemetryIntervals_1.TelemetryCheckIntervalsSchema.safeParse(telemetryIntervals);
    if (!parseResult.success) {
        validation.addError(new validatePolicyItem_1.InvalidPolicyItem(parseResult.error.message));
    }
    return validation.getOutput();
}
function isValidTelemetryIntervals(telemetryIntervals) {
    return telemetryIntervals !== undefined;
}
class InvalidTelemetryIntervals extends Error {
    constructor(telemetryIntervals) {
        super(`Telemetry Intervals are not valid ${telemetryIntervals}`);
    }
}
exports.InvalidTelemetryIntervals = InvalidTelemetryIntervals;
