"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidPowerActionScheduleSettingsPolicy = void 0;
exports.default = validatePowerActionScheduleSettingsPolicy;
const validatePowerActionScheduleSettings_1 = require("../../Device/Settings/Validation/validatePowerActionScheduleSettings");
const Validation_1 = require("../../Validation/Validation");
function validatePowerActionScheduleSettingsPolicy(settings) {
    const validation = (0, Validation_1.createValidation)(settings);
    if (!Array.isArray(settings)) {
        validation.addError(new InvalidPowerActionScheduleSettingsPolicy(settings));
    }
    else {
        settings === null || settings === void 0 ? void 0 : settings.forEach((setting) => {
            const settingValidation = (0, validatePowerActionScheduleSettings_1.default)(setting);
            validation.addError(...settingValidation.getErrors());
        });
    }
    return validation.getOutput();
}
class InvalidPowerActionScheduleSettingsPolicy extends Error {
    constructor(settings) {
        super(`PowerAction Schedule Settings Policy is not array: ${settings}`);
    }
}
exports.InvalidPowerActionScheduleSettingsPolicy = InvalidPowerActionScheduleSettingsPolicy;
