import { z } from 'zod';
import { IDeviceSettings, DeviceSettingsValue } from '../Device/Settings/DeviceSettings';
import { DeviceSettingsType } from '../Device/Settings/DeviceSettingsType';
import ApplicationType from '../Application/ApplicationType';
/**
 * Type guard for checking if the policy item is of the specified type.
 */
export declare function isPolicyItemOfType<T extends DeviceSettingsType>(policyItem: IPolicyItem, type: T): policyItem is IPolicyItem<T>;
/**
 * Value of the brightness is the only differs from general DeviceSettings
 */
export type BrightnessSettingsPolicy = z.infer<(typeof PolicyItemSchemas)[DeviceSettingsType.BRIGHTNESS]>['value'][number];
export declare const createPolicyItemBaseSchema: <TType extends DeviceSettingsType, TSchema extends z.Schema>(type: TType, valueSchema: TSchema) => z.ZodObject<{
    type: z.ZodLiteral<TType>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: TSchema;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, z.objectUtil.addQuestionMarks<z.baseObjectOutputType<{
    type: z.ZodLiteral<TType>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: TSchema;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}>, any> extends infer T ? { [k in keyof T]: z.objectUtil.addQuestionMarks<z.baseObjectOutputType<{
    type: z.ZodLiteral<TType>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: TSchema;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}>, any>[k]; } : never, z.baseObjectInputType<{
    type: z.ZodLiteral<TType>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: TSchema;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}> extends infer T_1 ? { [k_1 in keyof T_1]: z.baseObjectInputType<{
    type: z.ZodLiteral<TType>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: TSchema;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}>[k_1]; } : never>;
export declare const PolicyItemSchemas: {
    readonly VOLUME: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.VOLUME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            volume: number;
        }, {
            volume: number;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly BRIGHTNESS: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.BRIGHTNESS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
            brightness: z.ZodNumber;
        }, {
            time: z.ZodString;
        }>, "strict", z.ZodTypeAny, {
            time: string;
            brightness: number;
        }, {
            time: string;
            brightness: number;
        }>, "many">;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly TIMERS: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodNativeEnum<typeof import("../Device/Timer/NativeTimerType").NativeTimerType>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            type: import("../Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }, {
            type: import("../Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }>, "many">;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.TIMERS;
        value: {
            type: import("../Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.TIMERS;
        value: {
            type: import("../Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly PROPRIETARY_TIMERS: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.PROPRIETARY_TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodType<`TIMER_${number}`, z.ZodTypeDef, `TIMER_${number}`>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            keepAppletRunning: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }>, "many">;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly RESOLUTION: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.RESOLUTION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            width: z.ZodNumber;
            height: z.ZodNumber;
            framerate: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly ORIENTATION: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.ORIENTATION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            orientation: z.ZodNativeEnum<typeof import("../Device/Resolution/Orientation").default>;
            videoOrientation: z.ZodOptional<z.ZodNativeEnum<typeof import("../Device/Resolution/VideoOrientation").default>>;
        }, "strict", z.ZodTypeAny, {
            orientation: import("../Device/Resolution/Orientation").default;
            videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
        }, {
            orientation: import("../Device/Resolution/Orientation").default;
            videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("../Device/Resolution/Orientation").default;
            videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("../Device/Resolution/Orientation").default;
            videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly REMOTE_CONTROL: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.REMOTE_CONTROL>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
        }, {
            enabled: boolean;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly APPLICATION_VERSION: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.APPLICATION_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly FIRMWARE_VERSION: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.FIRMWARE_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly DEBUG: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.DEBUG>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletEnabled: z.ZodBoolean;
            nativeEnabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly DATETIME: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.DATETIME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            timezone: z.ZodNullable<z.ZodString>;
            ntpServer: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            timezone: string | null;
            ntpServer: string | null;
        }, {
            timezone: string | null;
            ntpServer: string | null;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly POWER_ACTIONS_SCHEDULE: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.POWER_ACTIONS_SCHEDULE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            uid: z.ZodString;
            powerType: z.ZodNativeEnum<typeof import("../Device/Power/PowerActionType").default>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("../Device/Power/PowerActionType").default;
        }, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("../Device/Power/PowerActionType").default;
        }>, "many">;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("../Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("../Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly TEMPERATURE: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.TEMPERATURE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            temperatureLimit: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            temperatureLimit: number;
        }, {
            temperatureLimit: number;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly AUTO_RECOVERY: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.AUTO_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            healthcheckIntervalMs: z.ZodOptional<z.ZodNumber>;
            autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly PEER_RECOVERY: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.PEER_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            urlLauncherAddress: z.ZodOptional<z.ZodString>;
            autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            autoEnableTimeoutMs?: number | undefined;
            urlLauncherAddress?: string | undefined;
        }, {
            enabled: boolean;
            autoEnableTimeoutMs?: number | undefined;
            urlLauncherAddress?: string | undefined;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            autoEnableTimeoutMs?: number | undefined;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            autoEnableTimeoutMs?: number | undefined;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly PROXY: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.PROXY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            uri: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            uri: string | null;
        }, {
            enabled: boolean;
            uri: string | null;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly CONNECTION_METHOD: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.CONNECTION_METHOD>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodNullable<z.ZodNativeEnum<typeof import("../Device/socketDriver").SocketDriver>>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.CONNECTION_METHOD;
        value: import("../Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.CONNECTION_METHOD;
        value: import("../Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly PACKAGES: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.PACKAGES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            toInstall: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
                applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
                packageName: z.ZodString;
                ownerOrganizationUid: z.ZodString;
                buildHash: z.ZodString;
                version: z.ZodString;
                build: z.ZodNullable<z.ZodString>;
                specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
            }, {
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                    sdkVersion: z.ZodNumber;
                    supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
                    multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
                    versionCode: z.ZodOptional<z.ZodNumber>;
                    targetSdkVersion: z.ZodOptional<z.ZodNumber>;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }>;
            }>, "strict", z.ZodTypeAny, {
                version: string;
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }, {
                version: string;
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }>, "many">;
            toUninstall: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
                applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
                packageName: z.ZodString;
                specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
            }, {
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                }, {
                    packageName: string;
                }>;
            }>, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }>, "many">;
        }, "strip", z.ZodTypeAny, {
            toInstall: {
                version: string;
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }, {
            toInstall: {
                version: string;
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                version: string;
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                version: string;
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly TELEMETRY_INTERVALS: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.TELEMETRY_INTERVALS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            telemetryIntervals: z.ZodObject<{
                screenshots: z.ZodOptional<z.ZodNumber>;
                temperature: z.ZodOptional<z.ZodNumber>;
                applicationVersion: z.ZodOptional<z.ZodNumber>;
                frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
                brightness: z.ZodOptional<z.ZodNumber>;
                datetime: z.ZodOptional<z.ZodNumber>;
                debug: z.ZodOptional<z.ZodNumber>;
                firmwareVersion: z.ZodOptional<z.ZodNumber>;
                orientation: z.ZodOptional<z.ZodNumber>;
                powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
                proprietaryTimers: z.ZodOptional<z.ZodNumber>;
                remoteControl: z.ZodOptional<z.ZodNumber>;
                resolution: z.ZodOptional<z.ZodNumber>;
                timers: z.ZodOptional<z.ZodNumber>;
                volume: z.ZodOptional<z.ZodNumber>;
                storage: z.ZodOptional<z.ZodNumber>;
                battery: z.ZodOptional<z.ZodNumber>;
                policy: z.ZodOptional<z.ZodNumber>;
                peerRecovery: z.ZodOptional<z.ZodNumber>;
                autoRecovery: z.ZodOptional<z.ZodNumber>;
                extendedManagement: z.ZodOptional<z.ZodNumber>;
                appModules: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodNumber>;
            }, "strict", z.ZodTypeAny, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                appModules?: number | undefined;
                default?: number | undefined;
            }, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                appModules?: number | undefined;
                default?: number | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                appModules?: number | undefined;
                default?: number | undefined;
            };
        }, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                appModules?: number | undefined;
                default?: number | undefined;
            };
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                appModules?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                appModules?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly APPLET: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.APPLET>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletUid: z.ZodString;
            appletVersion: z.ZodString;
            startsAt: z.ZodOptional<z.ZodDate>;
            endsAt: z.ZodOptional<z.ZodDate>;
            configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
            finishEvent: z.ZodOptional<z.ZodObject<{
                type: z.ZodNativeEnum<typeof import("../Timing/FinishEventType").FinishEventType>;
                data: z.ZodOptional<z.ZodAny>;
            }, "strip", z.ZodTypeAny, {
                type: import("../Timing/FinishEventType").FinishEventType;
                data?: any;
            }, {
                type: import("../Timing/FinishEventType").FinishEventType;
                data?: any;
            }>>;
            position: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            position?: number | undefined;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("../Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
        }, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            position?: number | undefined;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("../Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            position?: number | undefined;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("../Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            position?: number | undefined;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("../Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly EXTENDED_MANAGEMENT: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.EXTENDED_MANAGEMENT>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            url: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            url: string | null;
        }, {
            url: string | null;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly NETWORK_INTERFACES: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.NETWORK_INTERFACES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<z.objectUtil.extendShape<{
            name: z.ZodString;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            disabled: z.ZodOptional<z.ZodBoolean>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, {
            type: z.ZodLiteral<"wifi">;
            wifiStrength: z.ZodOptional<z.ZodNumber>;
            wifiSsid: z.ZodOptional<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            name: z.ZodString;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            disabled: z.ZodOptional<z.ZodBoolean>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, {
            type: z.ZodLiteral<"ethernet">;
        }>, "strip", z.ZodTypeAny, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            name: z.ZodString;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            disabled: z.ZodOptional<z.ZodBoolean>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, {
            type: z.ZodLiteral<"vpn">;
        }>, "strip", z.ZodTypeAny, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            name: z.ZodString;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            disabled: z.ZodOptional<z.ZodBoolean>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, {
            type: z.ZodLiteral<"mobile">;
        }>, "strip", z.ZodTypeAny, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>]>, "many">;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly DISPLAY_POWER_ON: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.DISPLAY_POWER_ON>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            powerOn: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            powerOn: boolean;
        }, {
            powerOn: boolean;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
    readonly SCREENSHOT_CAPTURE: z.ZodObject<{
        type: z.ZodLiteral<DeviceSettingsType.SCREENSHOT_CAPTURE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
        }, {
            enabled: boolean;
        }>;
        /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: DeviceSettingsType.SCREENSHOT_CAPTURE;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: DeviceSettingsType.SCREENSHOT_CAPTURE;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>;
};
export interface PolicyValue extends Required<Omit<IDeviceSettings, DeviceSettingsType.BRIGHTNESS>> {
    [DeviceSettingsType.BRIGHTNESS]: BrightnessSettingsPolicy[];
}
export declare const PolicyItemSchema: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.VOLUME>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        volume: z.ZodNumber;
    }, "strict", z.ZodTypeAny, {
        volume: number;
    }, {
        volume: number;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.VOLUME;
    value: {
        volume: number;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.VOLUME;
    value: {
        volume: number;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.BRIGHTNESS>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
        brightness: z.ZodNumber;
    }, {
        time: z.ZodString;
    }>, "strict", z.ZodTypeAny, {
        time: string;
        brightness: number;
    }, {
        time: string;
        brightness: number;
    }>, "many">;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.BRIGHTNESS;
    value: {
        time: string;
        brightness: number;
    }[];
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.BRIGHTNESS;
    value: {
        time: string;
        brightness: number;
    }[];
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.TIMERS>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodArray<z.ZodObject<{
        type: z.ZodNativeEnum<typeof import("../Device/Timer/NativeTimerType").NativeTimerType>;
        weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
        timeOn: z.ZodNullable<z.ZodString>;
        timeOff: z.ZodNullable<z.ZodString>;
        volume: z.ZodNumber;
    }, "strict", z.ZodTypeAny, {
        type: import("../Device/Timer/NativeTimerType").NativeTimerType;
        volume: number;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
    }, {
        type: import("../Device/Timer/NativeTimerType").NativeTimerType;
        volume: number;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
    }>, "many">;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.TIMERS;
    value: {
        type: import("../Device/Timer/NativeTimerType").NativeTimerType;
        volume: number;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
    }[];
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.TIMERS;
    value: {
        type: import("../Device/Timer/NativeTimerType").NativeTimerType;
        volume: number;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
    }[];
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.PROPRIETARY_TIMERS>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodArray<z.ZodObject<{
        type: z.ZodType<`TIMER_${number}`, z.ZodTypeDef, `TIMER_${number}`>;
        weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
        timeOn: z.ZodNullable<z.ZodString>;
        timeOff: z.ZodNullable<z.ZodString>;
        keepAppletRunning: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        type: `TIMER_${number}`;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
        keepAppletRunning?: boolean | undefined;
    }, {
        type: `TIMER_${number}`;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
        keepAppletRunning?: boolean | undefined;
    }>, "many">;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.PROPRIETARY_TIMERS;
    value: {
        type: `TIMER_${number}`;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
        keepAppletRunning?: boolean | undefined;
    }[];
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.PROPRIETARY_TIMERS;
    value: {
        type: `TIMER_${number}`;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
        keepAppletRunning?: boolean | undefined;
    }[];
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.RESOLUTION>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        width: z.ZodNumber;
        height: z.ZodNumber;
        framerate: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        height: number;
        width: number;
        framerate?: number | undefined;
    }, {
        height: number;
        width: number;
        framerate?: number | undefined;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.RESOLUTION;
    value: {
        height: number;
        width: number;
        framerate?: number | undefined;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.RESOLUTION;
    value: {
        height: number;
        width: number;
        framerate?: number | undefined;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.ORIENTATION>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        orientation: z.ZodNativeEnum<typeof import("../Device/Resolution/Orientation").default>;
        videoOrientation: z.ZodOptional<z.ZodNativeEnum<typeof import("../Device/Resolution/VideoOrientation").default>>;
    }, "strict", z.ZodTypeAny, {
        orientation: import("../Device/Resolution/Orientation").default;
        videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
    }, {
        orientation: import("../Device/Resolution/Orientation").default;
        videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.ORIENTATION;
    value: {
        orientation: import("../Device/Resolution/Orientation").default;
        videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.ORIENTATION;
    value: {
        orientation: import("../Device/Resolution/Orientation").default;
        videoOrientation?: import("../Device/Resolution/VideoOrientation").default | undefined;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.REMOTE_CONTROL>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        enabled: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
    }, {
        enabled: boolean;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.REMOTE_CONTROL;
    value: {
        enabled: boolean;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.REMOTE_CONTROL;
    value: {
        enabled: boolean;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.APPLICATION_VERSION>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        version: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        version: string;
    }, {
        version: string;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.APPLICATION_VERSION;
    value: {
        version: string;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.APPLICATION_VERSION;
    value: {
        version: string;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.FIRMWARE_VERSION>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        version: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        version: string;
    }, {
        version: string;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.FIRMWARE_VERSION;
    value: {
        version: string;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.FIRMWARE_VERSION;
    value: {
        version: string;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.DEBUG>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        appletEnabled: z.ZodBoolean;
        nativeEnabled: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    }, {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.DEBUG;
    value: {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.DEBUG;
    value: {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.DATETIME>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        timezone: z.ZodNullable<z.ZodString>;
        ntpServer: z.ZodNullable<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        timezone: string | null;
        ntpServer: string | null;
    }, {
        timezone: string | null;
        ntpServer: string | null;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.DATETIME;
    value: {
        timezone: string | null;
        ntpServer: string | null;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.DATETIME;
    value: {
        timezone: string | null;
        ntpServer: string | null;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.POWER_ACTIONS_SCHEDULE>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodArray<z.ZodObject<{
        uid: z.ZodString;
        powerType: z.ZodNativeEnum<typeof import("../Device/Power/PowerActionType").default>;
        weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
        time: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        time: string;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        uid: string;
        powerType: import("../Device/Power/PowerActionType").default;
    }, {
        time: string;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        uid: string;
        powerType: import("../Device/Power/PowerActionType").default;
    }>, "many">;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
    value: {
        time: string;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        uid: string;
        powerType: import("../Device/Power/PowerActionType").default;
    }[];
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
    value: {
        time: string;
        weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
        uid: string;
        powerType: import("../Device/Power/PowerActionType").default;
    }[];
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.TEMPERATURE>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        temperatureLimit: z.ZodNumber;
    }, "strict", z.ZodTypeAny, {
        temperatureLimit: number;
    }, {
        temperatureLimit: number;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.TEMPERATURE;
    value: {
        temperatureLimit: number;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.TEMPERATURE;
    value: {
        temperatureLimit: number;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.AUTO_RECOVERY>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        enabled: z.ZodBoolean;
        healthcheckIntervalMs: z.ZodOptional<z.ZodNumber>;
        autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
        healthcheckIntervalMs?: number | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }, {
        enabled: boolean;
        healthcheckIntervalMs?: number | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.AUTO_RECOVERY;
    value: {
        enabled: boolean;
        healthcheckIntervalMs?: number | undefined;
        autoEnableTimeoutMs?: number | undefined;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.AUTO_RECOVERY;
    value: {
        enabled: boolean;
        healthcheckIntervalMs?: number | undefined;
        autoEnableTimeoutMs?: number | undefined;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.PEER_RECOVERY>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        enabled: z.ZodBoolean;
        urlLauncherAddress: z.ZodOptional<z.ZodString>;
        autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
        autoEnableTimeoutMs?: number | undefined;
        urlLauncherAddress?: string | undefined;
    }, {
        enabled: boolean;
        autoEnableTimeoutMs?: number | undefined;
        urlLauncherAddress?: string | undefined;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.PEER_RECOVERY;
    value: {
        enabled: boolean;
        autoEnableTimeoutMs?: number | undefined;
        urlLauncherAddress?: string | undefined;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.PEER_RECOVERY;
    value: {
        enabled: boolean;
        autoEnableTimeoutMs?: number | undefined;
        urlLauncherAddress?: string | undefined;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.PROXY>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        enabled: z.ZodBoolean;
        uri: z.ZodNullable<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
        uri: string | null;
    }, {
        enabled: boolean;
        uri: string | null;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.PROXY;
    value: {
        enabled: boolean;
        uri: string | null;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.PROXY;
    value: {
        enabled: boolean;
        uri: string | null;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.CONNECTION_METHOD>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodNullable<z.ZodNativeEnum<typeof import("../Device/socketDriver").SocketDriver>>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.CONNECTION_METHOD;
    value: import("../Device/socketDriver").SocketDriver | null;
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.CONNECTION_METHOD;
    value: import("../Device/socketDriver").SocketDriver | null;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.PACKAGES>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        toInstall: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
            applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
            packageName: z.ZodString;
            ownerOrganizationUid: z.ZodString;
            buildHash: z.ZodString;
            version: z.ZodString;
            build: z.ZodNullable<z.ZodString>;
            specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
        }, {
            applicationType: z.ZodLiteral<"android">;
            specs: z.ZodObject<{
                packageName: z.ZodString;
                sdkVersion: z.ZodNumber;
                supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
                multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
                versionCode: z.ZodOptional<z.ZodNumber>;
                targetSdkVersion: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            }, {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            }>;
        }>, "strict", z.ZodTypeAny, {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }, {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }>, "many">;
        toUninstall: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
            applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
            packageName: z.ZodString;
            specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
        }, {
            applicationType: z.ZodLiteral<"android">;
            specs: z.ZodObject<{
                packageName: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                packageName: string;
            }, {
                packageName: string;
            }>;
        }>, "strict", z.ZodTypeAny, {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }, {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }>, "many">;
    }, "strip", z.ZodTypeAny, {
        toInstall: {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }[];
        toUninstall: {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }[];
    }, {
        toInstall: {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }[];
        toUninstall: {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }[];
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.PACKAGES;
    value: {
        toInstall: {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }[];
        toUninstall: {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }[];
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.PACKAGES;
    value: {
        toInstall: {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }[];
        toUninstall: {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }[];
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.TELEMETRY_INTERVALS>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        telemetryIntervals: z.ZodObject<{
            screenshots: z.ZodOptional<z.ZodNumber>;
            temperature: z.ZodOptional<z.ZodNumber>;
            applicationVersion: z.ZodOptional<z.ZodNumber>;
            frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
            brightness: z.ZodOptional<z.ZodNumber>;
            datetime: z.ZodOptional<z.ZodNumber>;
            debug: z.ZodOptional<z.ZodNumber>;
            firmwareVersion: z.ZodOptional<z.ZodNumber>;
            orientation: z.ZodOptional<z.ZodNumber>;
            powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
            proprietaryTimers: z.ZodOptional<z.ZodNumber>;
            remoteControl: z.ZodOptional<z.ZodNumber>;
            resolution: z.ZodOptional<z.ZodNumber>;
            timers: z.ZodOptional<z.ZodNumber>;
            volume: z.ZodOptional<z.ZodNumber>;
            storage: z.ZodOptional<z.ZodNumber>;
            battery: z.ZodOptional<z.ZodNumber>;
            policy: z.ZodOptional<z.ZodNumber>;
            peerRecovery: z.ZodOptional<z.ZodNumber>;
            autoRecovery: z.ZodOptional<z.ZodNumber>;
            extendedManagement: z.ZodOptional<z.ZodNumber>;
            appModules: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        }, {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        telemetryIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        };
    }, {
        telemetryIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        };
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.TELEMETRY_INTERVALS;
    value: {
        telemetryIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        };
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.TELEMETRY_INTERVALS;
    value: {
        telemetryIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        };
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.APPLET>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        appletUid: z.ZodString;
        appletVersion: z.ZodString;
        startsAt: z.ZodOptional<z.ZodDate>;
        endsAt: z.ZodOptional<z.ZodDate>;
        configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
        finishEvent: z.ZodOptional<z.ZodObject<{
            type: z.ZodNativeEnum<typeof import("../Timing/FinishEventType").FinishEventType>;
            data: z.ZodOptional<z.ZodAny>;
        }, "strip", z.ZodTypeAny, {
            type: import("../Timing/FinishEventType").FinishEventType;
            data?: any;
        }, {
            type: import("../Timing/FinishEventType").FinishEventType;
            data?: any;
        }>>;
        position: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        appletUid: string;
        appletVersion: string;
        configuration: Record<string, unknown>;
        position?: number | undefined;
        startsAt?: Date | undefined;
        endsAt?: Date | undefined;
        finishEvent?: {
            type: import("../Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
    }, {
        appletUid: string;
        appletVersion: string;
        configuration: Record<string, unknown>;
        position?: number | undefined;
        startsAt?: Date | undefined;
        endsAt?: Date | undefined;
        finishEvent?: {
            type: import("../Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.APPLET;
    value: {
        appletUid: string;
        appletVersion: string;
        configuration: Record<string, unknown>;
        position?: number | undefined;
        startsAt?: Date | undefined;
        endsAt?: Date | undefined;
        finishEvent?: {
            type: import("../Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.APPLET;
    value: {
        appletUid: string;
        appletVersion: string;
        configuration: Record<string, unknown>;
        position?: number | undefined;
        startsAt?: Date | undefined;
        endsAt?: Date | undefined;
        finishEvent?: {
            type: import("../Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.EXTENDED_MANAGEMENT>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        url: z.ZodNullable<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        url: string | null;
    }, {
        url: string | null;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.EXTENDED_MANAGEMENT;
    value: {
        url: string | null;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.EXTENDED_MANAGEMENT;
    value: {
        url: string | null;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.NETWORK_INTERFACES>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"wifi">;
        wifiStrength: z.ZodOptional<z.ZodNumber>;
        wifiSsid: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "wifi";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
        wifiStrength?: number | undefined;
        wifiSsid?: string | undefined;
    }, {
        name: string;
        type: "wifi";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
        wifiStrength?: number | undefined;
        wifiSsid?: string | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"ethernet">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "ethernet";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }, {
        name: string;
        type: "ethernet";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"vpn">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "vpn";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }, {
        name: string;
        type: "vpn";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"mobile">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "mobile";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }, {
        name: string;
        type: "mobile";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }>]>, "many">;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.NETWORK_INTERFACES;
    value: ({
        name: string;
        type: "wifi";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
        wifiStrength?: number | undefined;
        wifiSsid?: string | undefined;
    } | {
        name: string;
        type: "ethernet";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    } | {
        name: string;
        type: "vpn";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    } | {
        name: string;
        type: "mobile";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    })[];
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.NETWORK_INTERFACES;
    value: ({
        name: string;
        type: "wifi";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
        wifiStrength?: number | undefined;
        wifiSsid?: string | undefined;
    } | {
        name: string;
        type: "ethernet";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    } | {
        name: string;
        type: "vpn";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    } | {
        name: string;
        type: "mobile";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    })[];
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.DISPLAY_POWER_ON>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        powerOn: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        powerOn: boolean;
    }, {
        powerOn: boolean;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.DISPLAY_POWER_ON;
    value: {
        powerOn: boolean;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.DISPLAY_POWER_ON;
    value: {
        powerOn: boolean;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<DeviceSettingsType.SCREENSHOT_CAPTURE>;
    applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
    value: z.ZodObject<{
        enabled: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
    }, {
        enabled: boolean;
    }>;
    /** Automatically set the current date when updatedAt is missing to prevent mistakes and make it back compatible */
    updatedAt: z.ZodDefault<z.ZodDate>;
}, "strict", z.ZodTypeAny, {
    type: DeviceSettingsType.SCREENSHOT_CAPTURE;
    value: {
        enabled: boolean;
    };
    updatedAt: Date;
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
}, {
    type: DeviceSettingsType.SCREENSHOT_CAPTURE;
    value: {
        enabled: boolean;
    };
    applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    updatedAt?: Date | undefined;
}>]>;
export type AnyPolicyItem = z.infer<typeof PolicyItemSchema>;
/** @deprecated Use {@link IPolicyItem} instead */
export interface PolicyItemBase<T extends DeviceSettingsType = DeviceSettingsType, V extends PolicyValue[T] = PolicyValue[T]> {
    type: T;
    applicationType?: ApplicationType;
    value: V;
    /**
     * Updated is the same as the latest item update date
     */
    updatedAt: Date;
}
/**
 * Used for specifying of a PolicyItem based on DeviceSettingsType.
 * If the type argument is omitted, it's same as a union type {@link AnyPolicyItem}.
 */
type IPolicyItem<T extends DeviceSettingsType = DeviceSettingsType> = Extract<AnyPolicyItem, {
    type: T;
}>;
export default IPolicyItem;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.TEMPERATURE>} from `@signageos/common-types/dist/Device/Settings/DeviceSettings` instead */
export type TemperaturePolicy = DeviceSettingsValue<DeviceSettingsType.TEMPERATURE>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.VOLUME>} instead which is more convenient */
export type PolicyItemVolume = IPolicyItem<DeviceSettingsType.VOLUME>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.BRIGHTNESS>} instead which is more convenient */
export type PolicyItemBrightness = IPolicyItem<DeviceSettingsType.BRIGHTNESS>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.TIMERS>} instead which is more convenient */
export type PolicyItemTimers = IPolicyItem<DeviceSettingsType.TIMERS>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.PROPRIETARY_TIMERS>} instead which is more convenient */
export type PolicyItemProprietaryTimers = IPolicyItem<DeviceSettingsType.PROPRIETARY_TIMERS>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.RESOLUTION>} instead which is more convenient */
export type PolicyItemResolution = IPolicyItem<DeviceSettingsType.RESOLUTION>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.ORIENTATION>} instead which is more convenient */
export type PolicyItemOrientation = IPolicyItem<DeviceSettingsType.ORIENTATION>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.REMOTE_CONTROL>} instead which is more convenient */
export type PolicyItemRemoteControl = IPolicyItem<DeviceSettingsType.REMOTE_CONTROL>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.APPLICATION_VERSION>} instead which is more convenient */
export type PolicyItemApplicationVersion = IPolicyItem<DeviceSettingsType.APPLICATION_VERSION>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.FIRMWARE_VERSION>} instead which is more convenient */
export type PolicyItemFirmwareVersion = IPolicyItem<DeviceSettingsType.FIRMWARE_VERSION>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.DEBUG>} instead which is more convenient */
export type PolicyItemDebug = IPolicyItem<DeviceSettingsType.DEBUG>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.DATETIME>} instead which is more convenient */
export type PolicyItemDateTime = IPolicyItem<DeviceSettingsType.DATETIME>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.POWER_ACTIONS_SCHEDULE>} instead which is more convenient */
export type PolicyItemRebootSchedule = IPolicyItem<DeviceSettingsType.POWER_ACTIONS_SCHEDULE>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.TEMPERATURE>} instead which is more convenient */
export type PolicyItemTemperaturePolicy = IPolicyItem<DeviceSettingsType.TEMPERATURE>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.AUTO_RECOVERY>} instead which is more convenient */
export type PolicyItemAutoRecovery = IPolicyItem<DeviceSettingsType.AUTO_RECOVERY>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.PEER_RECOVERY>} instead which is more convenient */
export type PolicyItemPeerRecovery = IPolicyItem<DeviceSettingsType.PEER_RECOVERY>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.CONNECTION_METHOD>} instead which is more convenient */
export type PolicyItemConnectionMethod = IPolicyItem<DeviceSettingsType.CONNECTION_METHOD>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.PACKAGES>} instead which is more convenient */
export type PolicyItemPackages = IPolicyItem<DeviceSettingsType.PACKAGES>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.TELEMETRY_INTERVALS>} instead which is more convenient */
export type PolicyItemTelemetryIntervals = IPolicyItem<DeviceSettingsType.TELEMETRY_INTERVALS>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.APPLET>} instead which is more convenient */
export type PolicyItemApplet = IPolicyItem<DeviceSettingsType.APPLET>;
/** @deprecated Use {@link IPolicyItem<DeviceSettingsType.EXTENDED_MANAGEMENT>} instead which is more convenient */
export type PolicyExtendedManagement = IPolicyItem<DeviceSettingsType.EXTENDED_MANAGEMENT>;
