declare enum DeviceColumn {
    SYSTEM = "system",
    /** device name */
    NAME = "name",
    ORGANIZATION_NAME = "organizationName",
    ORGANIZATION_TITLE = "organizationTitle",
    ORGANIZATION_UID = "organizationUid",
    /** internally called identityHash */
    UID = "uid",
    MODEL = "model",
    FIRMWARE_VERSION = "firmwareVersion",
    FIRMWARE_TYPE = "firmwareType",
    /** physical identifier of device stored on device (sometimes called deviceUid internally) */
    DUID = "duid",
    APPLICATION_VERSION = "applicationVersion",
    MANAGEMENT_PACKAGE_VERSION = "managementPackageVersion",
    FRONT_PACKAGE_VERSION = "frontPackageVersion",
    FRONT_DISPLAY_VERSION = "frontDisplayVersion",
    SERIAL_NUMBER = "serialNumber",
    PIN_CODE = "pinCode",
    POWER_SUPPLY = "powerSupply",
    STORAGE = "storage",
    CURRENT_TIME = "currentTime",
    TIMEZONE = "timezone",
    WIFI_CONNECTION = "wifi",
    ETHERNET_CONNECTION = "ethernet",
    STATUS = "status",
    /** aliveAt */
    LAST_PING = "lastPing",
    /** lastProvisionedAt */
    PROVISIONED_AT = "provisionedAt",
    CONNECTION_TYPE = "connectionType",
    APPLET = "applet",
    APPLET_VERSION = "appletVersion",
    SSID = "ssid",
    WIFI_STRENGTH = "wifiStrength",
    BRAND = "brand",
    OS_VERSION = "osVersion",
    LOCATION = "location",
    TAGS = "tags",
    POLICY = "policy",
    LOCATION_ADDRESS = "locationAddress",
    LOCATION_GPS = "locationGPS",
    LOCATION_CUSTOM_ID = "locationCustomId"
}
export default DeviceColumn;
