/**
 * The enum value is used for front-display and display-* repos.
 * The devices are connecting with the specified driver based on this value.
 * It cannot be ever changed since this value is hardcoded in display with different versions of Core Apps.
 * Only new drivers can be added in future. But the support will be limited to new devices only.
 */
export declare enum SocketDriver {
    /**
     * The only correct string value for this Websocket is 'ws'.
     * The reason is that devices understands only those value by historical reasons. We cannot ever change it.
     */
    Websocket = "ws",
    Http = "http",
    SocketIo = "socket.io"
}
