"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidTemperature = exports.validKeys = void 0;
exports.default = validateTemperatureTelemetry;
exports.isValidTemperatureValue = isValidTemperatureValue;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    temperature: true,
};
function validateTemperatureTelemetry(settings) {
    var _a;
    const { temperature } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidTemperature = !isValidTemperatureValue(temperature);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notValidTemperature) {
        validation.addError(new InvalidTemperature(temperature));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function isValidTemperatureValue(temperature) {
    return typeof temperature === 'number' && Number.isInteger(temperature);
}
class InvalidTemperature extends Error {
    constructor(temperature) {
        super(`temperature has to be a number: ${temperature}`);
    }
}
exports.InvalidTemperature = InvalidTemperature;
