"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidBundledApplet = exports.validKeys = void 0;
exports.default = validateBundledAppletTelemetry;
exports.isBundledAppletTelemetry = isBundledAppletTelemetry;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    appletUid: true,
    appletVersion: true,
    config: true,
};
function validateBundledAppletTelemetry(settings) {
    const validation = (0, Validation_1.createValidation)(settings);
    if (settings !== null) {
        const notValidBundledAppletTelemetry = !isBundledAppletTelemetry(settings);
        const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
        if (notValidBundledAppletTelemetry) {
            validation.addError(new InvalidBundledApplet(settings));
        }
        validation.addError(...keysValidation.getErrors());
    }
    return validation.getOutput();
}
function isBundledAppletTelemetry(settings) {
    return (typeof settings === 'object' &&
        settings !== null &&
        'appletUid' in settings &&
        typeof (settings === null || settings === void 0 ? void 0 : settings.appletUid) === 'string' &&
        'appletVersion' in settings &&
        typeof (settings === null || settings === void 0 ? void 0 : settings.appletVersion) === 'string');
}
class InvalidBundledApplet extends Error {
    constructor(_settings) {
        super('bundled applet has to be valid');
    }
}
exports.InvalidBundledApplet = InvalidBundledApplet;
