/**
 * Formerly known as DeviceMonitoringType.
 * Defines all possible telemetries reported by devices.
 * Some of those items can be managed from server on the device and those should have its same named alternative DeviceSettingsType.
 * `DeviceTelemetryType` loosely corresponts with with `TelemetryConfigurationCheckInterval`
 */
export declare enum DeviceTelemetryType {
    VOLUME = "VOLUME",
    BRIGHTNESS = "BRIGHTNESS",
    TIMERS = "TIMERS",
    PROPRIETARY_TIMERS = "PROPRIETARY_TIMERS",
    RESOLUTION = "RESOLUTION",
    ORIENTATION = "ORIENTATION",
    REMOTE_CONTROL = "REMOTE_CONTROL",
    APPLICATION_VERSION = "APPLICATION_VERSION",
    FIRMWARE_VERSION = "FIRMWARE_VERSION",
    DEBUG = "DEBUG",
    DATETIME = "DATETIME",
    POWER_ACTIONS_SCHEDULE = "POWER_ACTIONS_SCHEDULE",
    TEMPERATURE = "TEMPERATURE",
    BUNDLED_APPLET = "BUNDLED_APPLET",
    AUTO_RECOVERY = "AUTO_RECOVERY",
    PEER_RECOVERY = "PEER_RECOVERY",
    PROXY = "PROXY",
    WIFI_STRENGTH = "WIFI_STRENGTH",
    FRONT_CAPABILITIES = "FRONT_CAPABILITIES",
    MANAGEMENT_CAPABILITIES = "MANAGEMENT_CAPABILITIES",
    DISPLAY_SETTING = "DISPLAY_SETTING",
    INPUT_SOURCE = "INPUT_SOURCE",
    FRONT_DISPLAY_VERSION = "FRONT_DISPLAY_VERSION",
    OFFLINE_RANGE = "OFFLINE_RANGE",
    ONLINE_STATUS = "ONLINE_STATUS",
    CONNECTION_METHOD = "CONNECTION_METHOD",
    EXTENDED_MANAGEMENT = "EXTENDED_MANAGEMENT",
    NETWORK_INTERFACES = "NETWORK_INTERFACES",
    DISPLAY_POWER_ON = "DISPLAY_POWER_ON",
    STORAGE = "STORAGE",
    APP_MODULES = "APP_MODULES",
    FEATURE_FLAGS = "FEATURE_FLAGS",
    CRYPTOGRAPHIC_KEY = "CRYPTOGRAPHIC_KEY"
}
